/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.ACE.DataTypes.Batch;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.BatchProgressFrame;
import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.ErrorGUI;
import jAudioFeatureExtractor.ModelListener;
import jAudioFeatureExtractor.OuterFrame;
import jAudioFeatureExtractor.Updater;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class BatchExecutionThread
extends Thread
implements Updater {
    Runnable suspendGUI;
    Runnable resumeGUI;
    RestoreSettings restoreSettings;
    BatchProgressFrame batchProgressFrame;
    UpdateGUI updateGui;
    ErrorGUI errorGUI;
    UpdateGUI updateGUI;
    OuterFrame outerFrame;
    Controller controller;
    FeatureExtractor[] features;
    boolean[] defaults;
    Vector<Batch> batches;
    boolean hasRun = false;

    public BatchExecutionThread(Controller controller, OuterFrame of) {
        this.outerFrame = of;
        this.controller = controller;
        this.batchProgressFrame = new BatchProgressFrame();
        this.batchProgressFrame.setVisible(true);
        this.errorGUI = new ErrorGUI(this.batchProgressFrame);
        this.updateGUI = new UpdateGUI();
        this.suspendGUI = new Runnable(){

            @Override
            public void run() {
                BatchExecutionThread.this.outerFrame.setEnabled(false);
            }
        };
        this.resumeGUI = new Runnable(){

            @Override
            public void run() {
                BatchExecutionThread.this.outerFrame.setEnabled(true);
            }
        };
        this.restoreSettings = new RestoreSettings();
        this.updateGUI = new UpdateGUI();
        controller.dm_.setUpdater(this);
        this.restoreSettings.fe = (FeatureExtractor[])controller.dm_.features.clone();
        this.restoreSettings.d = (boolean[])controller.dm_.defaults.clone();
        this.restoreSettings.c = controller;
    }

    @Override
    public void run() {
        ModelListener modelListener = this.controller.dm_.ml_;
        this.controller.dm_.ml_ = null;
        try {
            SwingUtilities.invokeAndWait(this.suspendGUI);
            int i = 0;
            while (i < this.controller.batches.size()) {
                File feature_values_save_file = new File(this.controller.batches.get(i).getDestinationFV());
                File feature_definitions_save_file = new File(this.controller.batches.get(i).getDestinationFK());
                this.controller.dm_.featureKey = new FileOutputStream(feature_values_save_file);
                this.controller.dm_.featureValue = new FileOutputStream(feature_definitions_save_file);
                this.controller.batches.get(i).execute();
                this.updateGUI.incrementBatch();
                SwingUtilities.invokeLater(this.updateGUI);
                ++i;
            }
            SwingUtilities.invokeLater(this.resumeGUI);
        }
        catch (Exception e) {
            this.errorGUI.e = e;
            SwingUtilities.invokeLater(this.errorGUI);
            SwingUtilities.invokeLater(this.resumeGUI);
        }
        this.hasRun = true;
        this.batchProgressFrame.setVisible(false);
        this.controller.dm_.ml_ = modelListener;
        try {
            SwingUtilities.invokeAndWait(this.restoreSettings);
            BatchExecutionThread.sleep(1000L);
        }
        catch (InterruptedException e) {
            System.err.println("INTERNAL ERROR: " + e.getMessage());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            System.err.println("INTERNAL ERROR: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void announceUpdate(int fileNumber, int fileDone) {
        this.updateGUI.setPos(fileNumber, fileDone);
        SwingUtilities.invokeLater(this.updateGUI);
    }

    @Override
    public void announceUpdate(int fileDone) {
        this.updateGUI.setPos(fileDone);
        SwingUtilities.invokeLater(this.updateGUI);
    }

    @Override
    public void setNumberOfFiles(int files) {
        this.updateGUI.setLengths(files);
        SwingUtilities.invokeLater(this.updateGUI);
    }

    @Override
    public void setFileLength(int windows) {
        this.updateGUI.setMaxWindows(windows);
        SwingUtilities.invokeLater(this.updateGUI);
    }

    class RestoreSettings
    implements Runnable {
        public Controller c;
        public FeatureExtractor[] fe;
        public boolean[] d;

        RestoreSettings() {
        }

        @Override
        public void run() {
            int i = 0;
            while (i < this.fe.length) {
                int numberOfAttributes = this.fe[i].getFeatureDefinition().attributes.length;
                int j = 0;
                while (j < numberOfAttributes) {
                    try {
                        this.c.dm_.features[i].setElement(j, this.fe[i].getElement(j));
                    }
                    catch (Exception e) {
                        System.err.println("INTERNAL ERROR: " + e.getMessage());
                        e.printStackTrace();
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    class UpdateGUI
    implements Runnable {
        int numberOfFiles;
        int file;
        int thisFileLength = 0;
        int pos;
        int batch = 0;

        UpdateGUI() {
        }

        public void setLengths(int file) {
            this.numberOfFiles = file;
        }

        public void setMaxWindows(int maxWin) {
            this.thisFileLength = maxWin;
        }

        public void setPos(int file, int pos) {
            this.file = file;
            this.pos = pos;
        }

        public void setPos(int pos) {
            this.pos = pos;
        }

        public void incrementBatch() {
            ++this.batch;
        }

        @Override
        public void run() {
            BatchExecutionThread.this.batchProgressFrame.setVisible(true);
            BatchExecutionThread.this.batchProgressFrame.fileProgressBar.setMaximum(this.thisFileLength);
            BatchExecutionThread.this.batchProgressFrame.batchProgressBar.setMaximum(this.numberOfFiles);
            BatchExecutionThread.this.batchProgressFrame.overallProgressBar.setMaximum(BatchExecutionThread.this.controller.batches.size());
            BatchExecutionThread.this.batchProgressFrame.fileProgressBar.setValue(this.pos);
            BatchExecutionThread.this.batchProgressFrame.batchProgressBar.setValue(this.file);
            BatchExecutionThread.this.batchProgressFrame.overallProgressBar.setValue(this.batch);
        }
    }
}

