/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class RelativeDifferenceFunction
extends FeatureExtractor {
    public RelativeDifferenceFunction() {
        String name = "Relative Difference Function";
        String decsription = "log of the derivative of RMS.  Used for onset detection.";
        this.definition = new FeatureDefinition(name, decsription, true, 1);
        this.dependencies = new String[]{"Root Mean Square", "Root Mean Square"};
        int[] nArray = new int[2];
        nArray[1] = -1;
        this.offsets = nArray;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] ret = new double[1];
        double difference = Math.abs(other_feature_values[0][0] - other_feature_values[1][0]);
        if (difference < 1.0E-50) {
            difference = 1.0E-50;
        }
        ret[0] = Math.log(difference);
        return ret;
    }

    @Override
    public Object clone() {
        return new RelativeDifferenceFunction();
    }
}

