/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class LPCRemoved
extends FeatureExtractor {
    private int num_dimensions = 10;

    public LPCRemoved() {
        String name = "LPC";
        String description = "Linear Predictive Encoding implemented from 'Numerical Recipes in C'";
        this.definition = new FeatureDefinition(name, description, true, this.num_dimensions, new String[]{"Number of LPC Coeffecients to Calculate"});
        this.dependencies = null;
        this.offsets = null;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] ret = new double[10];
        double[] wk1 = new double[samples.length];
        double[] wk2 = new double[samples.length];
        double[] wkm = new double[this.num_dimensions];
        wk1[0] = samples[0];
        wk2[samples.length - 2] = samples[samples.length - 1];
        int i = 1;
        while (i < samples.length - 1) {
            wk1[i] = samples[i];
            wk2[i - 1] = samples[i];
            ++i;
        }
        i = 0;
        while (i < this.num_dimensions) {
            double num = 0.0;
            double denom = 0.0;
            int j = 0;
            while (j < samples.length - i) {
                num += wk1[j] * wk2[j];
                denom += wk1[j] * wk1[j] + wk2[j] * wk2[j];
                ++j;
            }
            ret[i] = 2.0 * num / denom;
            j = 0;
            while (j < i) {
                ret[j] = wkm[j] - ret[i] * wkm[i - j];
                ++j;
            }
            j = 0;
            while (j <= i) {
                wkm[j] = ret[j];
                ++j;
            }
            j = 0;
            while (j < samples.length - i - 1) {
                int n = j;
                wk1[n] = wk1[n] - wkm[i] * wk2[j];
                wk2[j] = wk2[j + 1] - wkm[i] * wk1[j + 1];
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public void setNumberDimensions(int n) throws Exception {
        if (n < 1) {
            throw new Exception("LPC must have at least 1 dimension");
        }
        this.definition.dimensions = this.num_dimensions = n;
        this.parent.updateTable();
    }

    @Override
    public String getElement(int index) throws Exception {
        if (index != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + index + " sent to AreaMoments:getElement");
        }
        return Integer.toString(this.num_dimensions);
    }

    @Override
    public void setElement(int index, String value) throws Exception {
        if (index != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + index + " sent to AreaMoments:setElement");
        }
        try {
            int type = Integer.parseInt(value);
            this.setNumberDimensions(type);
        }
        catch (NumberFormatException e) {
            throw new Exception("Number of Coeffecients must be an integer");
        }
        catch (Exception e) {
            throw e;
        }
    }

    @Override
    public Object clone() {
        return new LPCRemoved();
    }
}

