/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class FractionOfLowEnergyWindows
extends FeatureExtractor {
    private int number_windows = 100;

    public FractionOfLowEnergyWindows() {
        String name = "Fraction Of Low Energy Windows";
        String description = "The fraction of the last 100 windows that has an RMS less than the mean RMS in the last 100 windows. This can indicate how much of a signal is quiet relative to the rest of the signal.";
        boolean is_sequential = true;
        int dimensions = 1;
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions);
        this.dependencies = new String[this.number_windows];
        int i = 0;
        while (i < this.dependencies.length) {
            this.dependencies[i] = "Root Mean Square";
            ++i;
        }
        this.offsets = new int[this.number_windows];
        i = 0;
        while (i < this.offsets.length) {
            this.offsets[i] = 0 - i;
            ++i;
        }
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double average = 0.0;
        int i = 0;
        while (i < other_feature_values.length) {
            average += other_feature_values[i][0];
            ++i;
        }
        average /= (double)other_feature_values.length;
        int count = 0;
        int i2 = 0;
        while (i2 < other_feature_values.length) {
            if (other_feature_values[i2][0] < average) {
                ++count;
            }
            ++i2;
        }
        double[] result = new double[]{(double)count / (double)other_feature_values.length};
        return result;
    }

    @Override
    public void setWindow(int n) throws Exception {
        if (n < 2) {
            throw new Exception("Fraction Of Low Energy Frames's window length must be 2 or greater");
        }
        this.number_windows = n;
        this.dependencies = new String[this.number_windows];
        this.offsets = new int[this.number_windows];
        int i = 0;
        while (i < this.number_windows) {
            this.dependencies[i] = "Root Mean Square";
            this.offsets[i] = 0 - i;
            ++i;
        }
    }

    @Override
    public String getElement(int index) throws Exception {
        if (index != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + index + " sent to FractionOfLowEnergyFrames:getElement");
        }
        return Integer.toString(this.number_windows);
    }

    @Override
    public void setElement(int index, String value) throws Exception {
        if (index != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + index + " sent to FractionOfLowEnergyFrames:setElement");
        }
        try {
            int type = Integer.parseInt(value);
            this.setWindow(type);
        }
        catch (Exception e) {
            throw new Exception("Length of Fraction Of Low Energy Frames's window must be an integer");
        }
    }

    @Override
    public Object clone() {
        FractionOfLowEnergyWindows ret = new FractionOfLowEnergyWindows();
        ret.number_windows = this.number_windows;
        return ret;
    }
}

