/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class Compactness
extends FeatureExtractor {
    public Compactness() {
        String name = "Compactness";
        String description = "A measure of the noisiness of a signal. Found by comparing the components of a window's magnitude spectrum with the magnitude spectrum of its neighbouring windows.";
        boolean is_sequential = true;
        int dimensions = 1;
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions);
        this.dependencies = new String[1];
        this.dependencies[0] = "Magnitude Spectrum";
        this.offsets = new int[1];
        this.offsets[0] = 0;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] mag_spec = other_feature_values[0];
        double compactness = 0.0;
        int i = 1;
        while (i < mag_spec.length - 1) {
            if (mag_spec[i - 1] > 0.0 && mag_spec[i] > 0.0 && mag_spec[i + 1] > 0.0) {
                compactness += Math.abs(20.0 * Math.log(mag_spec[i]) - 20.0 * (Math.log(mag_spec[i - 1]) + Math.log(mag_spec[i]) + Math.log(mag_spec[i + 1])) / 3.0);
            }
            ++i;
        }
        double[] result = new double[]{compactness};
        return result;
    }

    @Override
    public Object clone() {
        return new Compactness();
    }
}

