/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class BeatSum
extends FeatureExtractor {
    public BeatSum() {
        String name = "Beat Sum";
        String description = "The sum of all entries in the beat histogram. This is a good measure of the importance of regular beats in a signal.";
        boolean is_sequential = true;
        int dimensions = 1;
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions);
        this.dependencies = new String[1];
        this.dependencies[0] = "Beat Histogram";
        this.offsets = new int[1];
        this.offsets[0] = 0;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] beat_histogram = other_feature_values[0];
        if (beat_histogram != null) {
            double sum = 0.0;
            int i = 0;
            while (i < beat_histogram.length) {
                sum += beat_histogram[i];
                ++i;
            }
            double[] result = new double[]{sum};
            return result;
        }
        return null;
    }

    @Override
    public Object clone() {
        return new BeatSum();
    }
}

