/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.Aggregators;

import jAudioFeatureExtractor.ACE.DataTypes.AggregatorDefinition;
import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.Aggregators.Aggregator;

public class MultipleFeatureHistogram
extends Aggregator {
    String[] base = null;
    int[] indecis = null;
    int binsPerDimension;

    public MultipleFeatureHistogram() {
        this.metadata = new AggregatorDefinition("Multiple Feature Histogram", "a histogram of categories of input", false, new String[]{"Number of bins for 1st dimension"});
    }

    public MultipleFeatureHistogram(String[] fe, int bins) {
        this.base = fe;
        String name = "Histogram:";
        String description = "Histogram of concurrent changes in";
        int dimensions = 0;
        int i = 0;
        while (i < fe.length) {
            name = String.valueOf(name) + " " + fe[i];
            description = String.valueOf(description) + " " + fe[i];
            ++i;
        }
        this.definition = new FeatureDefinition(name, description, true, dimensions);
        this.binsPerDimension = bins;
        this.metadata = new AggregatorDefinition("Multiple Feature Histogram", "a histogram of categories of input", false, new String[]{"Number of bins for 1st dimension"});
    }

    @Override
    public String[] getParamaters() {
        return new String[]{Integer.toString(this.binsPerDimension)};
    }

    @Override
    public void setParameters(String[] features, String[] params) throws Exception {
        if (features == null) {
            throw new Exception("MultipleFeatureHistogram requires a list of features to aggregate");
        }
        if (params.length == 1) {
            try {
                this.binsPerDimension = Integer.parseInt(params[0]);
                this.base = features;
                String name = "Histogram:";
                String description = "Histogram of concurrent changes in";
                int dimensions = 0;
                int i = 0;
                while (i < features.length) {
                    name = String.valueOf(name) + " " + features[i];
                    description = String.valueOf(description) + " " + features[i];
                    ++i;
                }
                this.definition = new FeatureDefinition(name, description, true, dimensions);
            }
            catch (NumberFormatException e) {
                throw new Exception("Parameters to MultipleFeatureHistogram must be an integer");
            }
        } else {
            throw new Exception("MultipleFeatureHistogram takes exactly one argument of type integer");
        }
    }

    @Override
    public void aggregate(double[][][] values) throws Exception {
        int[][] featureList = super.collapseFeatures(values, this.indecis);
        this.definition.dimensions = (int)Math.pow(this.binsPerDimension, featureList.length);
        if (this.definition.dimensions > 0x100000) {
            throw new Exception("Number of dimensions for " + this.definition.name + " exceeds 1048576 - " + this.definition.dimensions);
        }
        int offset = super.calculateOffset(values, this.indecis);
        Integer[][] bins = new Integer[featureList.length][];
        int i = 0;
        while (i < featureList.length) {
            bins[i] = this.assignToBins(values, featureList[i][0], featureList[i][1]);
            ++i;
        }
        this.result = this.combineBins(bins, offset);
    }

    @Override
    public Object clone() {
        MultipleFeatureHistogram ret = new MultipleFeatureHistogram();
        if (this.base != null) {
            try {
                ret.setParameters(this.base, new String[]{Integer.toString(this.binsPerDimension)});
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return ret;
    }

    @Override
    public FeatureDefinition getFeatureDefinition() {
        return this.definition;
    }

    @Override
    public String[] getFeaturesToApply() {
        return this.base;
    }

    @Override
    public void init(int[] featureIndecis) throws Exception {
        this.indecis = featureIndecis;
    }

    Integer[] assignToBins(double[][][] values, int feature, int dimension) {
        Integer[] ret = new Integer[values.length];
        double[] bin = new double[this.binsPerDimension - 1];
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < values.length) {
            if (values[i][feature] != null && values[i][feature][dimension] > max) {
                max = values[i][feature][dimension];
            }
            if (values[i][feature] != null && values[i][feature][dimension] < min) {
                min = values[i][feature][dimension];
            }
            ++i;
        }
        double separator = (max - min) / (double)this.binsPerDimension;
        bin[0] = min + separator;
        int j = 1;
        while (j < bin.length) {
            bin[j] = bin[j - 1] + separator;
            ++j;
        }
        int i2 = 0;
        while (i2 < values.length) {
            if (values[i2][feature] == null) {
                ret[i2] = null;
            } else {
                ret[i2] = null;
                int j2 = 0;
                while (j2 < bin.length) {
                    if (values[i2][feature][dimension] < bin[j2]) {
                        ret[i2] = new Integer(j2);
                        break;
                    }
                    ++j2;
                }
                if (ret[i2] == null) {
                    ret[i2] = new Integer(this.binsPerDimension - 1);
                }
            }
            ++i2;
        }
        return ret;
    }

    double[] combineBins(Integer[][] bins, int offset) {
        int numDimensions = (int)Math.pow(this.binsPerDimension, bins.length);
        double[] ret = new double[numDimensions];
        int i = offset;
        while (i < bins[0].length) {
            int index = 0;
            int factor = 1;
            int j = 0;
            while (j < bins.length) {
                index += bins[j][i] * factor;
                factor *= this.binsPerDimension;
                ++j;
            }
            int n = index;
            ret[n] = ret[n] + 1.0;
            ++i;
        }
        i = 0;
        while (i < ret.length) {
            int n = i++;
            ret[n] = ret[n] / (double)(bins[0].length - offset);
        }
        return ret;
    }
}

