/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.Aggregators;

import jAudioFeatureExtractor.ACE.DataTypes.AggregatorDefinition;
import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class Mean
extends Aggregator {
    int feature;

    public Mean() {
        this.metadata = new AggregatorDefinition("Mean", "This is the overall average over all windows.", true, null);
    }

    @Override
    public String[] getFeaturesToApply() {
        return null;
    }

    @Override
    public FeatureDefinition getFeatureDefinition() {
        return this.definition;
    }

    @Override
    public void init(int[] featureIndeci) throws Exception {
        this.feature = featureIndeci[0];
    }

    @Override
    public Object clone() {
        return new Mean();
    }

    @Override
    public void setSource(FeatureExtractor feature) {
        FeatureDefinition this_def = feature.getFeatureDefinition();
        this.definition = new FeatureDefinition(String.valueOf(this_def.name) + " Overall Average", String.valueOf(this_def.description) + System.getProperty("line.separator") + "This is the overall average over all windows.", this_def.is_sequential, this_def.dimensions);
    }

    @Override
    public void aggregate(double[][][] values) {
        if (values == null || values.length == 0) {
            this.result = new double[1];
            this.result[0] = Double.NaN;
            this.definition.dimensions = 1;
        } else {
            int max = -1;
            int i = 0;
            while (i < values.length) {
                if (values[i][this.feature] != null && values[i][this.feature].length > max) {
                    max = values[i][this.feature].length;
                }
                ++i;
            }
            if (max <= 0) {
                this.result = new double[]{0.0};
                this.definition.dimensions = 1;
            } else {
                this.result = new double[max];
                this.definition.dimensions = max;
                i = 0;
                while (i < max) {
                    int count = 0;
                    double sum = 0.0;
                    int j = 0;
                    while (j < values.length) {
                        if (values[j][this.feature] != null && values[j][this.feature].length > i) {
                            sum += values[j][this.feature][i];
                            ++count;
                        }
                        ++j;
                    }
                    this.result[i] = count == 0 ? 0.0 : sum / (double)count;
                    ++i;
                }
            }
        }
    }
}

