/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.Aggregators;

import jAudioFeatureExtractor.ACE.DataTypes.AggregatorDefinition;
import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import java.util.Arrays;

public class AreaMoments
extends Aggregator {
    String[] featureNames = null;
    int[] featureNameIndecis = null;

    public AreaMoments() {
        this.metadata = new AggregatorDefinition("Area Moments", "Calculates the first 10 2D statistical moments for the given features", false, null);
    }

    @Override
    public void aggregate(double[][][] values) {
        int j;
        this.result = new double[10];
        double y3 = 0.0;
        double xy2 = 0.0;
        double x2y = 0.0;
        double x3 = 0.0;
        double y2 = 0.0;
        double xy = 0.0;
        double x2 = 0.0;
        double y = 0.0;
        double x = 0.0;
        int offset = super.calculateOffset(values, this.featureNameIndecis);
        int[][] featureIndecis = super.collapseFeatures(values, this.featureNameIndecis);
        this.result[0] = 0.0;
        int i = offset;
        while (i < values.length) {
            j = 0;
            while (j < featureIndecis.length) {
                this.result[0] = this.result[0] + values[i][featureIndecis[j][0]][featureIndecis[j][1]];
                ++j;
            }
            ++i;
        }
        if (this.result[0] == 0.0) {
            Arrays.fill(this.result, 0.0);
        } else {
            i = offset;
            while (i < values.length) {
                j = 0;
                while (j < featureIndecis.length) {
                    int feature = featureIndecis[j][0];
                    int dimension = featureIndecis[j][1];
                    double tmp = values[i][feature][dimension] / this.result[0];
                    x += tmp * (double)i;
                    y += tmp * (double)j;
                    x2 += tmp * (double)i * (double)i;
                    xy += tmp * (double)i * (double)j;
                    y2 += tmp * (double)j * (double)j;
                    x3 += tmp * (double)i * (double)i * (double)i;
                    x2y += tmp * (double)i * (double)i * (double)j;
                    xy2 += tmp * (double)i * (double)j * (double)j;
                    y3 += tmp * (double)j * (double)j * (double)j;
                    ++j;
                }
                ++i;
            }
            this.result[1] = x;
            this.result[2] = y;
            this.result[3] = x2 - x * x;
            this.result[4] = xy - x * y;
            this.result[5] = y2 - y * y;
            this.result[6] = 2.0 * Math.pow(x, 3.0) - 3.0 * x * x2 + x3;
            this.result[7] = 2.0 * x * xy - y * x2 + x2 * y;
            this.result[8] = 2.0 * y * xy - x * y2 + y2 * x;
            this.result[9] = 2.0 * Math.pow(y, 3.0) - 3.0 * y * y2 + y3;
        }
    }

    @Override
    public Object clone() {
        AreaMoments ret = new AreaMoments();
        if (this.featureNames != null) {
            ret.featureNames = (String[])this.featureNames.clone();
        }
        if (this.featureNameIndecis != null) {
            ret.featureNameIndecis = (int[])this.featureNameIndecis.clone();
        }
        return new AreaMoments();
    }

    @Override
    public FeatureDefinition getFeatureDefinition() {
        return this.definition;
    }

    @Override
    public String[] getFeaturesToApply() {
        return this.featureNames;
    }

    @Override
    public void init(int[] featureIndecis) throws Exception {
        if (featureIndecis.length != this.featureNames.length) {
            throw new Exception("INTERNAL ERROR (Agggregator.AreaMoments): number of feature indeci does not match number of features");
        }
        this.featureNameIndecis = featureIndecis;
    }

    @Override
    public void setParameters(String[] featureNames, String[] params) throws Exception {
        this.featureNames = featureNames;
        String names = featureNames[0];
        int i = 1;
        while (i < featureNames.length) {
            names = String.valueOf(names) + " " + featureNames[i];
            ++i;
        }
        this.definition = new FeatureDefinition("Area Moments: " + names, "2D moments constructed from features " + names + ".", true, 10);
    }
}

