/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IAxis;

public class FixedAxis
implements IAxis {
    private int bins;
    private double min;
    private double binWidth;
    private int xunder;
    private int xover;

    public FixedAxis(int bins, double min, double max) {
        if (bins < 1) {
            throw new IllegalArgumentException("bins=" + bins);
        }
        if (max <= min) {
            throw new IllegalArgumentException("max <= min");
        }
        this.bins = bins;
        this.min = min;
        this.binWidth = (max - min) / (double)bins;
    }

    @Override
    public double binCentre(int index) {
        return this.min + this.binWidth * (double)index + this.binWidth / 2.0;
    }

    @Override
    public double binLowerEdge(int index) {
        if (index == -2) {
            return Double.NEGATIVE_INFINITY;
        }
        if (index == -1) {
            return this.upperEdge();
        }
        return this.min + this.binWidth * (double)index;
    }

    @Override
    public int bins() {
        return this.bins;
    }

    @Override
    public double binUpperEdge(int index) {
        if (index == -2) {
            return this.min;
        }
        if (index == -1) {
            return Double.POSITIVE_INFINITY;
        }
        return this.min + this.binWidth * (double)(index + 1);
    }

    @Override
    public double binWidth(int index) {
        return this.binWidth;
    }

    @Override
    public int coordToIndex(double coord) {
        if (coord < this.min) {
            return -2;
        }
        int index = (int)Math.floor((coord - this.min) / this.binWidth);
        if (index >= this.bins) {
            return -1;
        }
        return index;
    }

    @Override
    public double lowerEdge() {
        return this.min;
    }

    @Override
    public double upperEdge() {
        return this.min + this.binWidth * (double)this.bins;
    }

    int xgetBin(double coord) {
        if (coord < this.min) {
            return this.xunder;
        }
        int index = (int)Math.floor((coord - this.min) / this.binWidth);
        if (index > this.bins) {
            return this.xover;
        }
        return index + 1;
    }

    int xmap(int index) {
        if (index >= this.bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return this.xunder;
        }
        if (index == -1) {
            return this.xover;
        }
        throw new IllegalArgumentException("bin=" + index);
    }
}

