/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.doublealgo.Formatter;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix3D;
import cern.colt.matrix.impl.Former;
import cern.colt.matrix.impl.FormerFactory;
import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.bin.BinFunction1D;
import hep.aida.bin.BinFunctions1D;

public class Converter {
    public double[] edges(IAxis axis) {
        int b = axis.bins();
        double[] bounds = new double[b + 1];
        int i = 0;
        while (i < b) {
            bounds[i] = axis.binLowerEdge(i);
            ++i;
        }
        bounds[b] = axis.upperEdge();
        return bounds;
    }

    String form(Former formatter, double value) {
        return formatter.form(value);
    }

    protected double[] toArrayErrors(IHistogram1D h) {
        int xBins = h.xAxis().bins();
        double[] array = new double[xBins];
        int j = xBins;
        while (--j >= 0) {
            array[j] = h.binError(j);
        }
        return array;
    }

    protected double[][] toArrayErrors(IHistogram2D h) {
        int xBins = h.xAxis().bins();
        int yBins = h.yAxis().bins();
        double[][] array = new double[xBins][yBins];
        int i = yBins;
        while (--i >= 0) {
            int j = xBins;
            while (--j >= 0) {
                array[j][i] = h.binError(j, i);
            }
        }
        return array;
    }

    protected double[] toArrayHeights(IHistogram1D h) {
        int xBins = h.xAxis().bins();
        double[] array = new double[xBins];
        int j = xBins;
        while (--j >= 0) {
            array[j] = h.binHeight(j);
        }
        return array;
    }

    protected double[][] toArrayHeights(IHistogram2D h) {
        int xBins = h.xAxis().bins();
        int yBins = h.yAxis().bins();
        double[][] array = new double[xBins][yBins];
        int i = yBins;
        while (--i >= 0) {
            int j = xBins;
            while (--j >= 0) {
                array[j][i] = h.binHeight(j, i);
            }
        }
        return array;
    }

    protected double[][][] toArrayHeights(IHistogram3D h) {
        int xBins = h.xAxis().bins();
        int yBins = h.yAxis().bins();
        int zBins = h.zAxis().bins();
        double[][][] array = new double[xBins][yBins][zBins];
        int j = xBins;
        while (--j >= 0) {
            int i = yBins;
            while (--i >= 0) {
                int k = zBins;
                while (--k >= 0) {
                    array[j][i][k] = h.binHeight(j, i, k);
                }
            }
        }
        return array;
    }

    protected static String toString(double[] array) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = array.length - 1;
        int i = 0;
        while (i <= maxIndex) {
            buf.append(array[i]);
            if (i < maxIndex) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    public String toString(IAxis axis) {
        StringBuffer buf = new StringBuffer();
        buf.append("Range: [" + axis.lowerEdge() + "," + axis.upperEdge() + ")");
        buf.append(", Bins: " + axis.bins());
        buf.append(", Bin edges: " + Converter.toString(this.edges(axis)) + "\n");
        return buf.toString();
    }

    public String toString(IHistogram1D h) {
        String columnAxisName = null;
        String rowAxisName = null;
        BinFunction1D[] aggr = null;
        String format = "%G";
        Former f = new FormerFactory().create(format);
        String sep = System.getProperty("line.separator");
        int[] minMaxBins = h.minMaxBins();
        String title = String.valueOf(h.title()) + ":" + sep + "   Entries=" + this.form(f, h.entries()) + ", ExtraEntries=" + this.form(f, h.extraEntries()) + sep + "   Mean=" + this.form(f, h.mean()) + ", Rms=" + this.form(f, h.rms()) + sep + "   MinBinHeight=" + this.form(f, h.binHeight(minMaxBins[0])) + ", MaxBinHeight=" + this.form(f, h.binHeight(minMaxBins[1])) + sep + "   Axis: " + "Bins=" + this.form(f, h.xAxis().bins()) + ", Min=" + this.form(f, h.xAxis().lowerEdge()) + ", Max=" + this.form(f, h.xAxis().upperEdge());
        String[] xEdges = new String[h.xAxis().bins()];
        int i = 0;
        while (i < h.xAxis().bins()) {
            xEdges[i] = this.form(f, h.xAxis().binLowerEdge(i));
            ++i;
        }
        String[] yEdges = null;
        DenseDoubleMatrix2D heights = new DenseDoubleMatrix2D(1, h.xAxis().bins());
        heights.viewRow(0).assign(this.toArrayHeights(h));
        return String.valueOf(title) + sep + "Heights:" + sep + new Formatter().toTitleString(heights, yEdges, xEdges, rowAxisName, columnAxisName, null, aggr);
    }

    public String toString(IHistogram2D h) {
        String columnAxisName = "X";
        String rowAxisName = "Y";
        BinFunction1D[] aggr = new BinFunction1D[]{BinFunctions1D.sum};
        String format = "%G";
        Former f = new FormerFactory().create(format);
        String sep = System.getProperty("line.separator");
        int[] minMaxBins = h.minMaxBins();
        String title = String.valueOf(h.title()) + ":" + sep + "   Entries=" + this.form(f, h.entries()) + ", ExtraEntries=" + this.form(f, h.extraEntries()) + sep + "   MeanX=" + this.form(f, h.meanX()) + ", RmsX=" + this.form(f, h.rmsX()) + sep + "   MeanY=" + this.form(f, h.meanY()) + ", RmsY=" + this.form(f, h.rmsX()) + sep + "   MinBinHeight=" + this.form(f, h.binHeight(minMaxBins[0], minMaxBins[1])) + ", MaxBinHeight=" + this.form(f, h.binHeight(minMaxBins[2], minMaxBins[3])) + sep + "   xAxis: " + "Bins=" + this.form(f, h.xAxis().bins()) + ", Min=" + this.form(f, h.xAxis().lowerEdge()) + ", Max=" + this.form(f, h.xAxis().upperEdge()) + sep + "   yAxis: " + "Bins=" + this.form(f, h.yAxis().bins()) + ", Min=" + this.form(f, h.yAxis().lowerEdge()) + ", Max=" + this.form(f, h.yAxis().upperEdge());
        String[] xEdges = new String[h.xAxis().bins()];
        int i = 0;
        while (i < h.xAxis().bins()) {
            xEdges[i] = this.form(f, h.xAxis().binLowerEdge(i));
            ++i;
        }
        Object[] yEdges = new String[h.yAxis().bins()];
        int i2 = 0;
        while (i2 < h.yAxis().bins()) {
            yEdges[i2] = this.form(f, h.yAxis().binLowerEdge(i2));
            ++i2;
        }
        new ObjectArrayList(yEdges).reverse();
        DoubleMatrix2D heights = new DenseDoubleMatrix2D(this.toArrayHeights(h));
        heights = heights.viewDice().viewRowFlip();
        return String.valueOf(title) + sep + "Heights:" + sep + new Formatter().toTitleString(heights, (String[])yEdges, xEdges, rowAxisName, columnAxisName, null, aggr);
    }

    public String toString(IHistogram3D h) {
        String columnAxisName = "X";
        String rowAxisName = "Y";
        String sliceAxisName = "Z";
        BinFunction1D[] aggr = new BinFunction1D[]{BinFunctions1D.sum};
        String format = "%G";
        Former f = new FormerFactory().create(format);
        String sep = System.getProperty("line.separator");
        int[] minMaxBins = h.minMaxBins();
        String title = String.valueOf(h.title()) + ":" + sep + "   Entries=" + this.form(f, h.entries()) + ", ExtraEntries=" + this.form(f, h.extraEntries()) + sep + "   MeanX=" + this.form(f, h.meanX()) + ", RmsX=" + this.form(f, h.rmsX()) + sep + "   MeanY=" + this.form(f, h.meanY()) + ", RmsY=" + this.form(f, h.rmsX()) + sep + "   MeanZ=" + this.form(f, h.meanZ()) + ", RmsZ=" + this.form(f, h.rmsZ()) + sep + "   MinBinHeight=" + this.form(f, h.binHeight(minMaxBins[0], minMaxBins[1], minMaxBins[2])) + ", MaxBinHeight=" + this.form(f, h.binHeight(minMaxBins[3], minMaxBins[4], minMaxBins[5])) + sep + "   xAxis: " + "Bins=" + this.form(f, h.xAxis().bins()) + ", Min=" + this.form(f, h.xAxis().lowerEdge()) + ", Max=" + this.form(f, h.xAxis().upperEdge()) + sep + "   yAxis: " + "Bins=" + this.form(f, h.yAxis().bins()) + ", Min=" + this.form(f, h.yAxis().lowerEdge()) + ", Max=" + this.form(f, h.yAxis().upperEdge()) + sep + "   zAxis: " + "Bins=" + this.form(f, h.zAxis().bins()) + ", Min=" + this.form(f, h.zAxis().lowerEdge()) + ", Max=" + this.form(f, h.zAxis().upperEdge());
        String[] xEdges = new String[h.xAxis().bins()];
        int i = 0;
        while (i < h.xAxis().bins()) {
            xEdges[i] = this.form(f, h.xAxis().binLowerEdge(i));
            ++i;
        }
        Object[] yEdges = new String[h.yAxis().bins()];
        int i2 = 0;
        while (i2 < h.yAxis().bins()) {
            yEdges[i2] = this.form(f, h.yAxis().binLowerEdge(i2));
            ++i2;
        }
        new ObjectArrayList(yEdges).reverse();
        Object[] zEdges = new String[h.zAxis().bins()];
        int i3 = 0;
        while (i3 < h.zAxis().bins()) {
            zEdges[i3] = this.form(f, h.zAxis().binLowerEdge(i3));
            ++i3;
        }
        new ObjectArrayList(zEdges).reverse();
        DoubleMatrix3D heights = new DenseDoubleMatrix3D(this.toArrayHeights(h));
        heights = heights.viewDice(2, 1, 0).viewSliceFlip().viewRowFlip();
        return String.valueOf(title) + sep + "Heights:" + sep + new Formatter().toTitleString(heights, (String[])zEdges, (String[])yEdges, xEdges, sliceAxisName, rowAxisName, columnAxisName, "", aggr);
    }

    public String toXML(IHistogram1D h) {
        StringBuffer buf = new StringBuffer();
        String sep = System.getProperty("line.separator");
        buf.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        buf.append(sep);
        buf.append("<!DOCTYPE plotML SYSTEM \"plotML.dtd\">");
        buf.append(sep);
        buf.append("<plotML>");
        buf.append(sep);
        buf.append("<plot>");
        buf.append(sep);
        buf.append("<dataArea>");
        buf.append(sep);
        buf.append("<data1d>");
        buf.append(sep);
        buf.append("<bins1d title=\"" + h.title() + "\">");
        buf.append(sep);
        int i = 0;
        while (i < h.xAxis().bins()) {
            buf.append(String.valueOf(h.binEntries(i)) + "," + h.binError(i));
            buf.append(sep);
            ++i;
        }
        buf.append("</bins1d>");
        buf.append(sep);
        buf.append("<binnedDataAxisAttributes type=\"double\" axis=\"x0\"");
        buf.append(" min=\"" + h.xAxis().lowerEdge() + "\"");
        buf.append(" max=\"" + h.xAxis().upperEdge() + "\"");
        buf.append(" numberOfBins=\"" + h.xAxis().bins() + "\"");
        buf.append("/>");
        buf.append(sep);
        buf.append("<statistics>");
        buf.append(sep);
        buf.append("<statistic name=\"Entries\" value=\"" + h.entries() + "\"/>");
        buf.append(sep);
        buf.append("<statistic name=\"Underflow\" value=\"" + h.binEntries(-2) + "\"/>");
        buf.append(sep);
        buf.append("<statistic name=\"Overflow\" value=\"" + h.binEntries(-1) + "\"/>");
        buf.append(sep);
        if (!Double.isNaN(h.mean())) {
            buf.append("<statistic name=\"Mean\" value=\"" + h.mean() + "\"/>");
            buf.append(sep);
        }
        if (!Double.isNaN(h.rms())) {
            buf.append("<statistic name=\"RMS\" value=\"" + h.rms() + "\"/>");
            buf.append(sep);
        }
        buf.append("</statistics>");
        buf.append(sep);
        buf.append("</data1d>");
        buf.append(sep);
        buf.append("</dataArea>");
        buf.append(sep);
        buf.append("</plot>");
        buf.append(sep);
        buf.append("</plotML>");
        buf.append(sep);
        return buf.toString();
    }

    public String toXML(IHistogram2D h) {
        StringBuffer out = new StringBuffer();
        String sep = System.getProperty("line.separator");
        out.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        out.append(sep);
        out.append("<!DOCTYPE plotML SYSTEM \"plotML.dtd\">");
        out.append(sep);
        out.append("<plotML>");
        out.append(sep);
        out.append("<plot>");
        out.append(sep);
        out.append("<dataArea>");
        out.append(sep);
        out.append("<data2d type=\"xxx\">");
        out.append(sep);
        out.append("<bins2d title=\"" + h.title() + "\" xSize=\"" + h.xAxis().bins() + "\" ySize=\"" + h.yAxis().bins() + "\">");
        out.append(sep);
        int i = 0;
        while (i < h.xAxis().bins()) {
            int j = 0;
            while (j < h.yAxis().bins()) {
                out.append(String.valueOf(h.binEntries(i, j)) + "," + h.binError(i, j));
                out.append(sep);
                ++j;
            }
            ++i;
        }
        out.append("</bins2d>");
        out.append(sep);
        out.append("<binnedDataAxisAttributes type=\"double\" axis=\"x0\"");
        out.append(" min=\"" + h.xAxis().lowerEdge() + "\"");
        out.append(" max=\"" + h.xAxis().upperEdge() + "\"");
        out.append(" numberOfBins=\"" + h.xAxis().bins() + "\"");
        out.append("/>");
        out.append(sep);
        out.append("<binnedDataAxisAttributes type=\"double\" axis=\"y0\"");
        out.append(" min=\"" + h.yAxis().lowerEdge() + "\"");
        out.append(" max=\"" + h.yAxis().upperEdge() + "\"");
        out.append(" numberOfBins=\"" + h.yAxis().bins() + "\"");
        out.append("/>");
        out.append(sep);
        out.append("</data2d>");
        out.append(sep);
        out.append("</dataArea>");
        out.append(sep);
        out.append("</plot>");
        out.append(sep);
        out.append("</plotML>");
        out.append(sep);
        return out.toString();
    }
}

