/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.ref.Histogram;

abstract class AbstractHistogram2D
extends Histogram
implements IHistogram2D {
    protected IAxis xAxis;
    protected IAxis yAxis;

    AbstractHistogram2D(String title) {
        super(title);
    }

    @Override
    public int allEntries() {
        int n = 0;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            int j = this.yAxis.bins();
            while (--j >= -2) {
                n += this.binEntries(i, j);
            }
        }
        return n;
    }

    @Override
    public int binEntriesX(int indexX) {
        return this.projectionX().binEntries(indexX);
    }

    @Override
    public int binEntriesY(int indexY) {
        return this.projectionY().binEntries(indexY);
    }

    @Override
    public double binHeightX(int indexX) {
        return this.projectionX().binHeight(indexX);
    }

    @Override
    public double binHeightY(int indexY) {
        return this.projectionY().binHeight(indexY);
    }

    @Override
    public int dimensions() {
        return 2;
    }

    @Override
    public int entries() {
        int n = 0;
        int i = 0;
        while (i < this.xAxis.bins()) {
            int j = 0;
            while (j < this.yAxis.bins()) {
                n += this.binEntries(i, j);
                ++j;
            }
            ++i;
        }
        return n;
    }

    @Override
    public int extraEntries() {
        return this.allEntries() - this.entries();
    }

    @Override
    public void fill(double x, double y) {
        this.fill(x, y, 1.0);
    }

    protected abstract IHistogram1D internalSliceX(String var1, int var2, int var3);

    protected abstract IHistogram1D internalSliceY(String var1, int var2, int var3);

    int mapX(int index) {
        int bins = this.xAxis.bins() + 2;
        if (index >= bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        if (index == -1) {
            return bins - 1;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    int mapY(int index) {
        int bins = this.yAxis.bins() + 2;
        if (index >= bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        if (index == -1) {
            return bins - 1;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    @Override
    public int[] minMaxBins() {
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        int minBinX = -1;
        int minBinY = -1;
        int maxBinX = -1;
        int maxBinY = -1;
        int i = this.xAxis.bins();
        while (--i >= 0) {
            int j = this.yAxis.bins();
            while (--j >= 0) {
                double value = this.binHeight(i, j);
                if (value < minValue) {
                    minValue = value;
                    minBinX = i;
                    minBinY = j;
                }
                if (!(value > maxValue)) continue;
                maxValue = value;
                maxBinX = i;
                maxBinY = j;
            }
        }
        int[] result = new int[]{minBinX, minBinY, maxBinX, maxBinY};
        return result;
    }

    @Override
    public IHistogram1D projectionX() {
        String newTitle = String.valueOf(this.title()) + " (projectionX)";
        return this.internalSliceX(newTitle, this.mapY(-2), this.mapY(-1));
    }

    @Override
    public IHistogram1D projectionY() {
        String newTitle = String.valueOf(this.title()) + " (projectionY)";
        return this.internalSliceY(newTitle, this.mapX(-2), this.mapX(-1));
    }

    @Override
    public IHistogram1D sliceX(int indexY) {
        int start = this.mapY(indexY);
        String newTitle = String.valueOf(this.title()) + " (sliceX [" + indexY + "])";
        return this.internalSliceX(newTitle, start, start);
    }

    @Override
    public IHistogram1D sliceX(int indexY1, int indexY2) {
        int start = this.mapY(indexY1);
        int stop = this.mapY(indexY2);
        String newTitle = String.valueOf(this.title()) + " (sliceX [" + indexY1 + ":" + indexY2 + "])";
        return this.internalSliceX(newTitle, start, stop);
    }

    @Override
    public IHistogram1D sliceY(int indexX) {
        int start = this.mapX(indexX);
        String newTitle = String.valueOf(this.title()) + " (sliceY [" + indexX + "])";
        return this.internalSliceY(newTitle, start, start);
    }

    @Override
    public IHistogram1D sliceY(int indexX1, int indexX2) {
        int start = this.mapX(indexX1);
        int stop = this.mapX(indexX2);
        String newTitle = String.valueOf(this.title()) + " (slicey [" + indexX1 + ":" + indexX2 + "])";
        return this.internalSliceY(newTitle, start, stop);
    }

    @Override
    public double sumAllBinHeights() {
        double n = 0.0;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            int j = this.yAxis.bins();
            while (--j >= -2) {
                n += this.binHeight(i, j);
            }
        }
        return n;
    }

    @Override
    public double sumBinHeights() {
        double n = 0.0;
        int i = 0;
        while (i < this.xAxis.bins()) {
            int j = 0;
            while (j < this.yAxis.bins()) {
                n += this.binHeight(i, j);
                ++j;
            }
            ++i;
        }
        return n;
    }

    @Override
    public double sumExtraBinHeights() {
        return this.sumAllBinHeights() - this.sumBinHeights();
    }

    @Override
    public IAxis xAxis() {
        return this.xAxis;
    }

    @Override
    public IAxis yAxis() {
        return this.yAxis;
    }
}

