/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.bin;

import cern.colt.buffer.DoubleBuffer;
import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.map.AbstractDoubleIntMap;
import cern.colt.map.OpenDoubleIntHashMap;
import cern.jet.random.Uniform;
import cern.jet.random.engine.RandomEngine;
import cern.jet.random.sampling.RandomSamplingAssistant;
import cern.jet.stat.Descriptive;
import hep.aida.bin.BinBinFunction1D;
import hep.aida.bin.QuantileBin1D;

public class DynamicBin1D
extends QuantileBin1D {
    protected DoubleArrayList elements = null;
    protected DoubleArrayList sortedElements = null;
    protected boolean fixedOrder = false;
    protected boolean isSorted = true;
    protected boolean isIncrementalStatValid = true;
    protected boolean isSumOfInversionsValid = true;
    protected boolean isSumOfLogarithmsValid = true;

    public DynamicBin1D() {
        this.clear();
        this.elements = new DoubleArrayList();
        this.sortedElements = new DoubleArrayList(0);
        this.fixedOrder = false;
        this.hasSumOfLogarithms = true;
        this.hasSumOfInversions = true;
    }

    @Override
    public synchronized void add(double element) {
        this.elements.add(element);
        this.invalidateAll();
    }

    @Override
    public synchronized void addAllOfFromTo(DoubleArrayList list, int from, int to) {
        this.elements.addAllOfFromTo(list, from, to);
        this.invalidateAll();
    }

    public synchronized double aggregate(DoubleDoubleFunction aggr, DoubleFunction f) {
        int s = this.size();
        if (s == 0) {
            return Double.NaN;
        }
        double a = f.apply(this.elements.getQuick(s - 1));
        int i = s - 1;
        while (--i >= 0) {
            a = aggr.apply(a, f.apply(this.elements.getQuick(i)));
        }
        return a;
    }

    @Override
    public synchronized void clear() {
        super.clear();
        if (this.elements != null) {
            this.elements.clear();
        }
        if (this.sortedElements != null) {
            this.sortedElements.clear();
        }
        this.validateAll();
    }

    @Override
    protected void clearAllMeasures() {
        super.clearAllMeasures();
    }

    @Override
    public synchronized Object clone() {
        DynamicBin1D clone = (DynamicBin1D)super.clone();
        if (this.elements != null) {
            clone.elements = clone.elements.copy();
        }
        if (this.sortedElements != null) {
            clone.sortedElements = clone.sortedElements.copy();
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized double correlation(DynamicBin1D other) {
        DynamicBin1D dynamicBin1D = other;
        synchronized (dynamicBin1D) {
            return this.covariance(other) / (this.standardDeviation() * other.standardDeviation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized double covariance(DynamicBin1D other) {
        DynamicBin1D dynamicBin1D = other;
        synchronized (dynamicBin1D) {
            if (this.size() != other.size()) {
                throw new IllegalArgumentException("both bins must have same size");
            }
            double s = 0.0;
            int i = this.size();
            while (--i >= 0) {
                s += this.elements.getQuick(i) * other.elements.getQuick(i);
            }
            double cov = (s - this.sum() * other.sum() / (double)this.size()) / (double)this.size();
            return cov;
        }
    }

    public synchronized DoubleArrayList elements() {
        return this.elements_unsafe().copy();
    }

    protected synchronized DoubleArrayList elements_unsafe() {
        return this.elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean equals(Object object) {
        if (!(object instanceof DynamicBin1D)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DynamicBin1D other = (DynamicBin1D)object;
        double[] s1 = this.sortedElements_unsafe().elements();
        DynamicBin1D dynamicBin1D = other;
        synchronized (dynamicBin1D) {
            double[] s2 = other.sortedElements_unsafe().elements();
            int n = this.size();
            return DynamicBin1D.includes(s1, s2, 0, n, 0, n) && DynamicBin1D.includes(s2, s1, 0, n, 0, n);
        }
    }

    private static boolean includes(double[] array1, double[] array2, int first1, int last1, int first2, int last2) {
        while (first1 < last1 && first2 < last2) {
            if (array2[first2] < array1[first1]) {
                return false;
            }
            if (array1[first1] < array2[first2]) {
                ++first1;
                continue;
            }
            ++first1;
            ++first2;
        }
        return first2 == last2;
    }

    public synchronized void frequencies(DoubleArrayList distinctElements, IntArrayList frequencies) {
        Descriptive.frequencies(this.sortedElements_unsafe(), distinctElements, frequencies);
    }

    private synchronized AbstractDoubleIntMap frequencyMap() {
        OpenDoubleIntHashMap map = new OpenDoubleIntHashMap();
        int i = this.size();
        while (--i >= 0) {
            double element = this.elements.getQuick(i);
            ((AbstractDoubleIntMap)map).put(element, 1 + ((AbstractDoubleIntMap)map).get(element));
        }
        return map;
    }

    @Override
    public int getMaxOrderForSumOfPowers() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinOrderForSumOfPowers() {
        return Integer.MIN_VALUE;
    }

    protected void invalidateAll() {
        this.isSorted = false;
        this.isIncrementalStatValid = false;
        this.isSumOfInversionsValid = false;
        this.isSumOfLogarithmsValid = false;
    }

    @Override
    public synchronized boolean isRebinnable() {
        return true;
    }

    @Override
    public synchronized double max() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.max;
    }

    @Override
    public synchronized double min() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.min;
    }

    @Override
    public synchronized double moment(int k, double c) {
        return Descriptive.moment(this.elements, k, c);
    }

    @Override
    public synchronized double quantile(double phi) {
        return Descriptive.quantile(this.sortedElements_unsafe(), phi);
    }

    @Override
    public synchronized double quantileInverse(double element) {
        return Descriptive.quantileInverse(this.sortedElements_unsafe(), element);
    }

    @Override
    public DoubleArrayList quantiles(DoubleArrayList percentages) {
        return Descriptive.quantiles(this.sortedElements_unsafe(), percentages);
    }

    public synchronized boolean removeAllOf(DoubleArrayList list) {
        boolean changed = this.elements.removeAll(list);
        if (changed) {
            this.clearAllMeasures();
            this.invalidateAll();
            this.size = 0;
            if (this.fixedOrder) {
                this.sortedElements.removeAll(list);
                this.isSorted = true;
            }
        }
        return changed;
    }

    public synchronized void sample(int n, boolean withReplacement, RandomEngine randomGenerator, DoubleBuffer buffer) {
        if (randomGenerator == null) {
            randomGenerator = Uniform.makeDefaultGenerator();
        }
        buffer.clear();
        if (!withReplacement) {
            if (n > this.size()) {
                throw new IllegalArgumentException("n must be less than or equal to size()");
            }
            RandomSamplingAssistant sampler = new RandomSamplingAssistant(n, this.size(), randomGenerator);
            int i = n;
            while (--i >= 0) {
                if (!sampler.sampleNextElement()) continue;
                buffer.add(this.elements.getQuick(i));
            }
        } else {
            Uniform uniform = new Uniform(randomGenerator);
            int s = this.size();
            int i = n;
            while (--i >= 0) {
                buffer.add(this.elements.getQuick(uniform.nextIntFromTo(0, s - 1)));
            }
            buffer.flush();
        }
    }

    public synchronized DynamicBin1D sampleBootstrap(DynamicBin1D other, int resamples, RandomEngine randomGenerator, BinBinFunction1D function) {
        if (randomGenerator == null) {
            randomGenerator = Uniform.makeDefaultGenerator();
        }
        int maxCapacity = 1000;
        int s1 = this.size();
        int s2 = other.size();
        DynamicBin1D sample1 = new DynamicBin1D();
        DoubleBuffer buffer1 = sample1.buffered(Math.min(maxCapacity, s1));
        DynamicBin1D sample2 = new DynamicBin1D();
        DoubleBuffer buffer2 = sample2.buffered(Math.min(maxCapacity, s2));
        DynamicBin1D bootstrap = new DynamicBin1D();
        DoubleBuffer bootBuffer = bootstrap.buffered(Math.min(maxCapacity, resamples));
        int i = resamples;
        while (--i >= 0) {
            sample1.clear();
            sample2.clear();
            this.sample(s1, true, randomGenerator, buffer1);
            other.sample(s2, true, randomGenerator, buffer2);
            bootBuffer.add(function.apply(sample1, sample2));
        }
        bootBuffer.flush();
        return bootstrap;
    }

    public void setFixedOrder(boolean fixedOrder) {
        this.fixedOrder = fixedOrder;
    }

    @Override
    public synchronized int size() {
        return this.elements.size();
    }

    protected void sort() {
        if (!this.isSorted) {
            if (this.fixedOrder) {
                this.sortedElements.clear();
                this.sortedElements.addAllOfFromTo(this.elements, 0, this.elements.size() - 1);
                this.sortedElements.sort();
            } else {
                this.updateIncrementalStats();
                this.invalidateAll();
                this.elements.sort();
                this.isIncrementalStatValid = true;
            }
            this.isSorted = true;
        }
    }

    public synchronized DoubleArrayList sortedElements() {
        return this.sortedElements_unsafe().copy();
    }

    protected synchronized DoubleArrayList sortedElements_unsafe() {
        this.sort();
        if (this.fixedOrder) {
            return this.sortedElements;
        }
        return this.elements;
    }

    public synchronized void standardize(double mean, double standardDeviation) {
        Descriptive.standardize(this.elements, mean, standardDeviation);
        this.clearAllMeasures();
        this.invalidateAll();
        this.size = 0;
    }

    @Override
    public synchronized double sum() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.sum;
    }

    @Override
    public synchronized double sumOfInversions() {
        if (!this.isSumOfInversionsValid) {
            this.updateSumOfInversions();
        }
        return this.sumOfInversions;
    }

    @Override
    public synchronized double sumOfLogarithms() {
        if (!this.isSumOfLogarithmsValid) {
            this.updateSumOfLogarithms();
        }
        return this.sumOfLogarithms;
    }

    @Override
    public synchronized double sumOfPowers(int k) {
        if (k >= -1 && k <= 2) {
            return super.sumOfPowers(k);
        }
        return Descriptive.sumOfPowers(this.elements, k);
    }

    @Override
    public synchronized double sumOfSquares() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.sum_xx;
    }

    @Override
    public synchronized String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        DoubleArrayList distinctElements = new DoubleArrayList();
        IntArrayList frequencies = new IntArrayList();
        this.frequencies(distinctElements, frequencies);
        if (distinctElements.size() < 100) {
            buf.append("Distinct elements: " + distinctElements + "\n");
            buf.append("Frequencies: " + frequencies + "\n");
        } else {
            buf.append("Distinct elements & frequencies not printed (too many).");
        }
        return buf.toString();
    }

    public synchronized void trim(int s, int l) {
        DoubleArrayList elems = this.sortedElements();
        this.clear();
        this.addAllOfFromTo(elems, s, elems.size() - 1 - l);
    }

    public synchronized double trimmedMean(int s, int l) {
        return Descriptive.trimmedMean(this.sortedElements_unsafe(), this.mean(), s, l);
    }

    @Override
    public synchronized void trimToSize() {
        this.elements.trimToSize();
        this.sortedElements.clear();
        this.sortedElements.trimToSize();
        if (this.fixedOrder) {
            this.isSorted = false;
        }
    }

    protected void updateIncrementalStats() {
        double[] arguments = new double[]{this.min, this.max, this.sum, this.sum_xx};
        Descriptive.incrementalUpdate(this.elements, this.size, this.elements.size() - 1, arguments);
        this.min = arguments[0];
        this.max = arguments[1];
        this.sum = arguments[2];
        this.sum_xx = arguments[3];
        this.isIncrementalStatValid = true;
        this.size = this.elements.size();
    }

    protected void updateSumOfInversions() {
        this.sumOfInversions = Descriptive.sumOfInversions(this.elements, 0, this.size() - 1);
        this.isSumOfInversionsValid = true;
    }

    protected void updateSumOfLogarithms() {
        this.sumOfLogarithms = Descriptive.sumOfLogarithms(this.elements, 0, this.size() - 1);
        this.isSumOfLogarithmsValid = true;
    }

    protected void validateAll() {
        this.isSorted = true;
        this.isIncrementalStatValid = true;
        this.isSumOfInversionsValid = true;
        this.isSumOfLogarithmsValid = true;
    }
}

