/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.bin;

import cern.colt.buffer.DoubleBuffer;
import cern.colt.buffer.DoubleBufferConsumer;
import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import hep.aida.bin.AbstractBin;

public abstract class AbstractBin1D
extends AbstractBin
implements DoubleBufferConsumer {
    protected AbstractBin1D() {
    }

    public abstract void add(double var1);

    @Override
    public final synchronized void addAllOf(DoubleArrayList list) {
        this.addAllOfFromTo(list, 0, list.size() - 1);
    }

    public synchronized void addAllOfFromTo(DoubleArrayList list, int from, int to) {
        int i = from;
        while (i <= to) {
            this.add(list.getQuick(i));
            ++i;
        }
    }

    public synchronized DoubleBuffer buffered(int capacity) {
        return new DoubleBuffer(this, capacity);
    }

    public String compareWith(AbstractBin1D other) {
        StringBuffer buf = new StringBuffer();
        buf.append("\nDifferences [percent]");
        buf.append("\nSize: " + this.relError(this.size(), other.size()) + " %");
        buf.append("\nSum: " + this.relError(this.sum(), other.sum()) + " %");
        buf.append("\nSumOfSquares: " + this.relError(this.sumOfSquares(), other.sumOfSquares()) + " %");
        buf.append("\nMin: " + this.relError(this.min(), other.min()) + " %");
        buf.append("\nMax: " + this.relError(this.max(), other.max()) + " %");
        buf.append("\nMean: " + this.relError(this.mean(), other.mean()) + " %");
        buf.append("\nRMS: " + this.relError(this.rms(), other.rms()) + " %");
        buf.append("\nVariance: " + this.relError(this.variance(), other.variance()) + " %");
        buf.append("\nStandard deviation: " + this.relError(this.standardDeviation(), other.standardDeviation()) + " %");
        buf.append("\nStandard error: " + this.relError(this.standardError(), other.standardError()) + " %");
        buf.append("\n");
        return buf.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AbstractBin1D)) {
            return false;
        }
        AbstractBin1D other = (AbstractBin1D)object;
        return this.size() == other.size() && this.min() == other.min() && this.max() == other.max() && this.sum() == other.sum() && this.sumOfSquares() == other.sumOfSquares();
    }

    public abstract double max();

    public synchronized double mean() {
        return this.sum() / (double)this.size();
    }

    public abstract double min();

    protected double relError(double measure1, double measure2) {
        return 100.0 * (1.0 - measure1 / measure2);
    }

    public synchronized double rms() {
        return Descriptive.rms(this.size(), this.sumOfSquares());
    }

    public synchronized double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public synchronized double standardError() {
        return Descriptive.standardError(this.size(), this.variance());
    }

    public abstract double sum();

    public abstract double sumOfSquares();

    @Override
    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append("\n-------------");
        buf.append("\nSize: " + this.size());
        buf.append("\nSum: " + this.sum());
        buf.append("\nSumOfSquares: " + this.sumOfSquares());
        buf.append("\nMin: " + this.min());
        buf.append("\nMax: " + this.max());
        buf.append("\nMean: " + this.mean());
        buf.append("\nRMS: " + this.rms());
        buf.append("\nVariance: " + this.variance());
        buf.append("\nStandard deviation: " + this.standardDeviation());
        buf.append("\nStandard error: " + this.standardError());
        buf.append("\n");
        return buf.toString();
    }

    @Override
    public synchronized void trimToSize() {
    }

    public synchronized double variance() {
        return Descriptive.sampleVariance(this.size(), this.sum(), this.sumOfSquares());
    }
}

