/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.colt.PersistentObject;
import cern.colt.function.DoubleProcedure;
import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import cern.jet.stat.quantile.DoubleQuantileFinder;

class ExactDoubleQuantileFinder
extends PersistentObject
implements DoubleQuantileFinder {
    protected DoubleArrayList buffer = new DoubleArrayList(0);
    protected boolean isSorted;

    public ExactDoubleQuantileFinder() {
        this.clear();
    }

    @Override
    public void add(double value) {
        this.buffer.add(value);
        this.isSorted = false;
    }

    @Override
    public void addAllOf(DoubleArrayList values) {
        this.addAllOfFromTo(values, 0, values.size() - 1);
    }

    @Override
    public void addAllOfFromTo(DoubleArrayList values, int from, int to) {
        this.buffer.addAllOfFromTo(values, from, to);
        this.isSorted = false;
    }

    @Override
    public void clear() {
        this.buffer.clear();
        this.buffer.trimToSize();
        this.isSorted = false;
    }

    @Override
    public Object clone() {
        ExactDoubleQuantileFinder copy = (ExactDoubleQuantileFinder)super.clone();
        if (this.buffer != null) {
            copy.buffer = copy.buffer.copy();
        }
        return copy;
    }

    public boolean contains(double element) {
        this.sort();
        return this.buffer.binarySearch(element) >= 0;
    }

    @Override
    public boolean forEach(DoubleProcedure procedure) {
        double[] theElements = this.buffer.elements();
        int theSize = (int)this.size();
        int i = 0;
        while (i < theSize) {
            if (procedure.apply(theElements[i++])) continue;
            return false;
        }
        return true;
    }

    @Override
    public long memory() {
        return this.buffer.elements().length;
    }

    @Override
    public double phi(double element) {
        this.sort();
        return Descriptive.rankInterpolated(this.buffer, element) / (double)this.size();
    }

    @Override
    public DoubleArrayList quantileElements(DoubleArrayList phis) {
        this.sort();
        return Descriptive.quantiles(this.buffer, phis);
    }

    @Override
    public long size() {
        return this.buffer.size();
    }

    protected void sort() {
        if (!this.isSorted) {
            this.buffer.sort();
            this.isSorted = true;
        }
    }

    public String toString() {
        String s = this.getClass().getName();
        s = s.substring(s.lastIndexOf(46) + 1);
        return String.valueOf(s) + "(mem=" + this.memory() + ", size=" + this.size() + ")";
    }

    @Override
    public long totalMemory() {
        return this.memory();
    }
}

