/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractDiscreteDistribution;
import cern.jet.random.engine.RandomEngine;

public class Zeta
extends AbstractDiscreteDistribution {
    protected double ro;
    protected double pk;
    protected double c;
    protected double d;
    protected double ro_prev = -1.0;
    protected double pk_prev = -1.0;
    protected double maxlongint = 9.223372036854776E18;
    protected static Zeta shared = new Zeta(1.0, 1.0, Zeta.makeDefaultGenerator());

    public Zeta(double ro, double pk, RandomEngine randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(ro, pk);
    }

    protected long generateZeta(double ro, double pk, RandomEngine randomGenerator) {
        long k;
        if (ro != this.ro_prev || pk != this.pk_prev) {
            this.ro_prev = ro;
            this.pk_prev = pk;
            if (ro < pk) {
                this.c = pk - 0.5;
                this.d = 0.0;
            } else {
                this.c = ro - 0.5;
                this.d = (1.0 + ro) * Math.log((1.0 + pk) / (1.0 + ro));
            }
        }
        while (true) {
            double u = randomGenerator.raw();
            double v = randomGenerator.raw();
            double x = (this.c + 0.5) * Math.exp(-Math.log(u) / ro) - this.c;
            if (x <= 0.5 || x >= this.maxlongint) continue;
            k = (int)(x + 0.5);
            double e = -Math.log(v);
            if (!(e < (1.0 + ro) * Math.log(((double)k + pk) / (x + this.c)) - this.d)) break;
        }
        return k;
    }

    @Override
    public int nextInt() {
        return (int)this.generateZeta(this.ro, this.pk, this.randomGenerator);
    }

    public void setState(double ro, double pk) {
        this.ro = ro;
        this.pk = pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int staticNextInt(double ro, double pk) {
        Zeta zeta = shared;
        synchronized (zeta) {
            shared.setState(ro, pk);
            return shared.nextInt();
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.ro + "," + this.pk + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomGenerator) {
        Zeta zeta = shared;
        synchronized (zeta) {
            shared.setRandomGenerator(randomGenerator);
        }
    }
}

