/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Functions;
import java.io.Serializable;

public class QRDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private DoubleMatrix2D QR;
    private int m;
    private int n;
    private DoubleMatrix1D Rdiag;

    public QRDecomposition(DoubleMatrix2D A) {
        Property.DEFAULT.checkRectangular(A);
        Functions F = Functions.functions;
        this.QR = A.copy();
        this.m = A.rows();
        this.n = A.columns();
        this.Rdiag = A.like1D(this.n);
        DoubleDoubleFunction hypot = Algebra.hypotFunction();
        DoubleMatrix1D[] QRcolumns = new DoubleMatrix1D[this.n];
        DoubleMatrix1D[] QRcolumnsPart = new DoubleMatrix1D[this.n];
        int k = 0;
        while (k < this.n) {
            QRcolumns[k] = this.QR.viewColumn(k);
            QRcolumnsPart[k] = this.QR.viewColumn(k).viewPart(k, this.m - k);
            ++k;
        }
        k = 0;
        while (k < this.n) {
            double nrm = 0.0;
            int i = k;
            while (i < this.m) {
                nrm = Algebra.hypot(nrm, this.QR.getQuick(i, k));
                ++i;
            }
            if (nrm != 0.0) {
                if (this.QR.getQuick(k, k) < 0.0) {
                    nrm = -nrm;
                }
                QRcolumnsPart[k].assign(Functions.div(nrm));
                this.QR.setQuick(k, k, this.QR.getQuick(k, k) + 1.0);
                int j = k + 1;
                while (j < this.n) {
                    DoubleMatrix1D QRcolj = this.QR.viewColumn(j).viewPart(k, this.m - k);
                    double s = QRcolumnsPart[k].zDotProduct(QRcolj);
                    s = -s / this.QR.getQuick(k, k);
                    int i2 = k;
                    while (i2 < this.m) {
                        this.QR.setQuick(i2, j, this.QR.getQuick(i2, j) + s * this.QR.getQuick(i2, k));
                        ++i2;
                    }
                    ++j;
                }
            }
            this.Rdiag.setQuick(k, -nrm);
            ++k;
        }
    }

    public DoubleMatrix2D getH() {
        return Algebra.DEFAULT.trapezoidalLower(this.QR.copy());
    }

    public DoubleMatrix2D getQ() {
        Functions F = Functions.functions;
        DoubleMatrix2D Q = this.QR.like();
        int k = this.n - 1;
        while (k >= 0) {
            DoubleMatrix1D QRcolk = this.QR.viewColumn(k).viewPart(k, this.m - k);
            Q.setQuick(k, k, 1.0);
            int j = k;
            while (j < this.n) {
                if (this.QR.getQuick(k, k) != 0.0) {
                    DoubleMatrix1D Qcolj = Q.viewColumn(j).viewPart(k, this.m - k);
                    double s = QRcolk.zDotProduct(Qcolj);
                    s = -s / this.QR.getQuick(k, k);
                    Qcolj.assign(QRcolk, Functions.plusMult(s));
                }
                ++j;
            }
            --k;
        }
        return Q;
    }

    public DoubleMatrix2D getR() {
        DoubleMatrix2D R = this.QR.like(this.n, this.n);
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                if (i < j) {
                    R.setQuick(i, j, this.QR.getQuick(i, j));
                } else if (i == j) {
                    R.setQuick(i, j, this.Rdiag.getQuick(i));
                } else {
                    R.setQuick(i, j, 0.0);
                }
                ++j;
            }
            ++i;
        }
        return R;
    }

    public boolean hasFullRank() {
        int j = 0;
        while (j < this.n) {
            if (this.Rdiag.getQuick(j) == 0.0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public DoubleMatrix2D solve(DoubleMatrix2D B) {
        int j;
        Functions F = Functions.functions;
        if (B.rows() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        int nx = B.columns();
        DoubleMatrix2D X = B.copy();
        int k = 0;
        while (k < this.n) {
            j = 0;
            while (j < nx) {
                double s = 0.0;
                int i = k;
                while (i < this.m) {
                    s += this.QR.getQuick(i, k) * X.getQuick(i, j);
                    ++i;
                }
                s = -s / this.QR.getQuick(k, k);
                i = k;
                while (i < this.m) {
                    X.setQuick(i, j, X.getQuick(i, j) + s * this.QR.getQuick(i, k));
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        k = this.n - 1;
        while (k >= 0) {
            j = 0;
            while (j < nx) {
                X.setQuick(k, j, X.getQuick(k, j) / this.Rdiag.getQuick(k));
                ++j;
            }
            int i = 0;
            while (i < k) {
                int j2 = 0;
                while (j2 < nx) {
                    X.setQuick(i, j2, X.getQuick(i, j2) - X.getQuick(k, j2) * this.QR.getQuick(i, k));
                    ++j2;
                }
                ++i;
            }
            --k;
        }
        return X.viewPart(0, 0, this.n, nx);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String unknown = "Illegal operation or error: ";
        buf.append("-----------------------------------------------------------------\n");
        buf.append("QRDecomposition(A) --> hasFullRank(A), H, Q, R, pseudo inverse(A)\n");
        buf.append("-----------------------------------------------------------------\n");
        buf.append("hasFullRank = ");
        try {
            buf.append(String.valueOf(this.hasFullRank()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\nH = ");
        try {
            buf.append(String.valueOf(this.getH()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\nQ = ");
        try {
            buf.append(String.valueOf(this.getQ()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\nR = ");
        try {
            buf.append(String.valueOf(this.getR()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\npseudo inverse(A) = ");
        try {
            buf.append(String.valueOf(this.solve(DoubleFactory2D.dense.identity(this.QR.rows()))));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        return buf.toString();
    }
}

