/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Functions;
import java.io.Serializable;

public class CholeskyDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private DoubleMatrix2D L;
    private int n;
    private boolean isSymmetricPositiveDefinite;

    public CholeskyDecomposition(DoubleMatrix2D A) {
        Property.DEFAULT.checkSquare(A);
        this.n = A.rows();
        this.L = A.like(this.n, this.n);
        this.isSymmetricPositiveDefinite = A.columns() == this.n;
        DoubleMatrix1D[] Lrows = new DoubleMatrix1D[this.n];
        int j = 0;
        while (j < this.n) {
            Lrows[j] = this.L.viewRow(j);
            ++j;
        }
        j = 0;
        while (j < this.n) {
            double d = 0.0;
            int k = 0;
            while (k < j) {
                double s = Lrows[k].zDotProduct(Lrows[j], 0, k);
                s = (A.getQuick(j, k) - s) / this.L.getQuick(k, k);
                Lrows[j].setQuick(k, s);
                d += s * s;
                this.isSymmetricPositiveDefinite = this.isSymmetricPositiveDefinite && A.getQuick(k, j) == A.getQuick(j, k);
                ++k;
            }
            d = A.getQuick(j, j) - d;
            this.isSymmetricPositiveDefinite = this.isSymmetricPositiveDefinite && d > 0.0;
            this.L.setQuick(j, j, Math.sqrt(Math.max(d, 0.0)));
            k = j + 1;
            while (k < this.n) {
                this.L.setQuick(j, k, 0.0);
                ++k;
            }
            ++j;
        }
    }

    public DoubleMatrix2D getL() {
        return this.L;
    }

    public boolean isSymmetricPositiveDefinite() {
        return this.isSymmetricPositiveDefinite;
    }

    public DoubleMatrix2D solve(DoubleMatrix2D B) {
        DoubleMatrix2D X = B.copy();
        int nx = B.columns();
        int c = 0;
        while (c < nx) {
            int k;
            double sum;
            int i = 0;
            while (i < this.n) {
                sum = B.getQuick(i, c);
                k = i - 1;
                while (k >= 0) {
                    sum -= this.L.getQuick(i, k) * X.getQuick(k, c);
                    --k;
                }
                X.setQuick(i, c, sum / this.L.getQuick(i, i));
                ++i;
            }
            i = this.n - 1;
            while (i >= 0) {
                sum = X.getQuick(i, c);
                k = i + 1;
                while (k < this.n) {
                    sum -= this.L.getQuick(k, i) * X.getQuick(k, c);
                    ++k;
                }
                X.setQuick(i, c, sum / this.L.getQuick(i, i));
                --i;
            }
            ++c;
        }
        return X;
    }

    private DoubleMatrix2D XXXsolveBuggy(DoubleMatrix2D B) {
        int i;
        Functions F = Functions.functions;
        if (B.rows() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isSymmetricPositiveDefinite) {
            throw new IllegalArgumentException("Matrix is not symmetric positive definite.");
        }
        DoubleMatrix2D X = B.copy();
        int nx = B.columns();
        DoubleMatrix1D[] Xrows = new DoubleMatrix1D[this.n];
        int k = 0;
        while (k < this.n) {
            Xrows[k] = X.viewRow(k);
            ++k;
        }
        k = 0;
        while (k < this.n) {
            i = k + 1;
            while (i < this.n) {
                Xrows[i].assign(Xrows[k], Functions.minusMult(this.L.getQuick(i, k)));
                ++i;
            }
            Xrows[k].assign(Functions.div(this.L.getQuick(k, k)));
            ++k;
        }
        k = this.n - 1;
        while (k >= 0) {
            Xrows[k].assign(Functions.div(this.L.getQuick(k, k)));
            i = 0;
            while (i < k) {
                Xrows[i].assign(Xrows[k], Functions.minusMult(this.L.getQuick(k, i)));
                ++i;
            }
            --k;
        }
        return X;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String unknown = "Illegal operation or error: ";
        buf.append("--------------------------------------------------------------------------\n");
        buf.append("CholeskyDecomposition(A) --> isSymmetricPositiveDefinite(A), L, inverse(A)\n");
        buf.append("--------------------------------------------------------------------------\n");
        buf.append("isSymmetricPositiveDefinite = ");
        try {
            buf.append(String.valueOf(this.isSymmetricPositiveDefinite()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\nL = ");
        try {
            buf.append(String.valueOf(this.getL()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\ninverse(A) = ");
        try {
            buf.append(String.valueOf(this.solve(DoubleFactory2D.dense.identity(this.L.rows()))));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        return buf.toString();
    }
}

