/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.matrix.impl.AbstractFormatter;
import cern.colt.matrix.impl.AbstractMatrix;

public abstract class AbstractMatrix3D
extends AbstractMatrix {
    protected int slices;
    protected int rows;
    protected int columns;
    protected int sliceStride;
    protected int rowStride;
    protected int columnStride;
    protected int sliceZero;
    protected int rowZero;
    protected int columnZero;

    protected AbstractMatrix3D() {
    }

    protected int _columnOffset(int absRank) {
        return absRank;
    }

    protected int _columnRank(int rank) {
        return this.columnZero + rank * this.columnStride;
    }

    protected int _rowOffset(int absRank) {
        return absRank;
    }

    protected int _rowRank(int rank) {
        return this.rowZero + rank * this.rowStride;
    }

    protected int _sliceOffset(int absRank) {
        return absRank;
    }

    protected int _sliceRank(int rank) {
        return this.sliceZero + rank * this.sliceStride;
    }

    protected void checkBox(int slice, int row, int column, int depth, int height, int width) {
        if (slice < 0 || depth < 0 || slice + depth > this.slices || row < 0 || height < 0 || row + height > this.rows || column < 0 || width < 0 || column + width > this.columns) {
            throw new IndexOutOfBoundsException(String.valueOf(this.toStringShort()) + ", slice:" + slice + ", row:" + row + " ,column:" + column + ", depth:" + depth + " ,height:" + height + ", width:" + width);
        }
    }

    protected void checkColumn(int column) {
        if (column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("Attempted to access " + this.toStringShort() + " at column=" + column);
        }
    }

    protected void checkColumnIndexes(int[] indexes) {
        int i = indexes.length;
        while (--i >= 0) {
            int index = indexes[i];
            if (index >= 0 && index < this.columns) continue;
            this.checkColumn(index);
        }
    }

    protected void checkRow(int row) {
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("Attempted to access " + this.toStringShort() + " at row=" + row);
        }
    }

    protected void checkRowIndexes(int[] indexes) {
        int i = indexes.length;
        while (--i >= 0) {
            int index = indexes[i];
            if (index >= 0 && index < this.rows) continue;
            this.checkRow(index);
        }
    }

    public void checkShape(AbstractMatrix3D B) {
        if (this.slices != B.slices || this.rows != B.rows || this.columns != B.columns) {
            throw new IllegalArgumentException("Incompatible dimensions: " + this.toStringShort() + " and " + B.toStringShort());
        }
    }

    public void checkShape(AbstractMatrix3D B, AbstractMatrix3D C) {
        if (this.slices != B.slices || this.rows != B.rows || this.columns != B.columns || this.slices != C.slices || this.rows != C.rows || this.columns != C.columns) {
            throw new IllegalArgumentException("Incompatible dimensions: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
    }

    protected void checkSlice(int slice) {
        if (slice < 0 || slice >= this.slices) {
            throw new IndexOutOfBoundsException("Attempted to access " + this.toStringShort() + " at slice=" + slice);
        }
    }

    protected void checkSliceIndexes(int[] indexes) {
        int i = indexes.length;
        while (--i >= 0) {
            int index = indexes[i];
            if (index >= 0 && index < this.slices) continue;
            this.checkSlice(index);
        }
    }

    public int columns() {
        return this.columns;
    }

    protected int index(int slice, int row, int column) {
        return this._sliceOffset(this._sliceRank(slice)) + this._rowOffset(this._rowRank(row)) + this._columnOffset(this._columnRank(column));
    }

    public int rows() {
        return this.rows;
    }

    protected void setUp(int slices, int rows, int columns) {
        this.setUp(slices, rows, columns, 0, 0, 0, rows * columns, columns, 1);
    }

    protected void setUp(int slices, int rows, int columns, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride) {
        if (slices < 0 || rows < 0 || columns < 0) {
            throw new IllegalArgumentException("negative size");
        }
        if ((double)slices * (double)rows * (double)columns > 2.147483647E9) {
            throw new IllegalArgumentException("matrix too large");
        }
        this.slices = slices;
        this.rows = rows;
        this.columns = columns;
        this.sliceZero = sliceZero;
        this.rowZero = rowZero;
        this.columnZero = columnZero;
        this.sliceStride = sliceStride;
        this.rowStride = rowStride;
        this.columnStride = columnStride;
        this.isNoView = true;
    }

    protected int[] shape() {
        int[] shape = new int[]{this.slices, this.rows, this.columns};
        return shape;
    }

    @Override
    public int size() {
        return this.slices * this.rows * this.columns;
    }

    public int slices() {
        return this.slices;
    }

    public String toStringShort() {
        return AbstractFormatter.shape(this);
    }

    protected AbstractMatrix3D vColumnFlip() {
        if (this.columns > 0) {
            this.columnZero += (this.columns - 1) * this.columnStride;
            this.columnStride = -this.columnStride;
            this.isNoView = false;
        }
        return this;
    }

    protected AbstractMatrix3D vDice(int axis0, int axis1, int axis2) {
        int d = 3;
        if (axis0 < 0 || axis0 >= d || axis1 < 0 || axis1 >= d || axis2 < 0 || axis2 >= d || axis0 == axis1 || axis0 == axis2 || axis1 == axis2) {
            throw new IllegalArgumentException("Illegal Axes: " + axis0 + ", " + axis1 + ", " + axis2);
        }
        int[] shape = this.shape();
        this.slices = shape[axis0];
        this.rows = shape[axis1];
        this.columns = shape[axis2];
        int[] strides = new int[]{this.sliceStride, this.rowStride, this.columnStride};
        this.sliceStride = strides[axis0];
        this.rowStride = strides[axis1];
        this.columnStride = strides[axis2];
        this.isNoView = false;
        return this;
    }

    protected AbstractMatrix3D vPart(int slice, int row, int column, int depth, int height, int width) {
        this.checkBox(slice, row, column, depth, height, width);
        this.sliceZero += this.sliceStride * slice;
        this.rowZero += this.rowStride * row;
        this.columnZero += this.columnStride * column;
        this.slices = depth;
        this.rows = height;
        this.columns = width;
        this.isNoView = false;
        return this;
    }

    protected AbstractMatrix3D vRowFlip() {
        if (this.rows > 0) {
            this.rowZero += (this.rows - 1) * this.rowStride;
            this.rowStride = -this.rowStride;
            this.isNoView = false;
        }
        return this;
    }

    protected AbstractMatrix3D vSliceFlip() {
        if (this.slices > 0) {
            this.sliceZero += (this.slices - 1) * this.sliceStride;
            this.sliceStride = -this.sliceStride;
            this.isNoView = false;
        }
        return this;
    }

    protected AbstractMatrix3D vStrides(int sliceStride, int rowStride, int columnStride) {
        if (sliceStride <= 0 || rowStride <= 0 || columnStride <= 0) {
            throw new IndexOutOfBoundsException("illegal strides: " + sliceStride + ", " + rowStride + ", " + columnStride);
        }
        this.sliceStride *= sliceStride;
        this.rowStride *= rowStride;
        this.columnStride *= columnStride;
        if (this.slices != 0) {
            this.slices = (this.slices - 1) / sliceStride + 1;
        }
        if (this.rows != 0) {
            this.rows = (this.rows - 1) / rowStride + 1;
        }
        if (this.columns != 0) {
            this.columns = (this.columns - 1) / columnStride + 1;
        }
        this.isNoView = false;
        return this;
    }
}

