/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.function.ObjectFunction;
import cern.colt.function.ObjectObjectFunction;
import cern.colt.function.ObjectProcedure;
import cern.colt.list.IntArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.AbstractMatrix1D;
import cern.colt.matrix.objectalgo.Formatter;
import cern.colt.matrix.objectalgo.Sorting;

public abstract class ObjectMatrix1D
extends AbstractMatrix1D {
    protected ObjectMatrix1D() {
    }

    public Object aggregate(ObjectObjectFunction aggr, ObjectFunction f) {
        if (this.size == 0) {
            return null;
        }
        Object a = f.apply(this.getQuick(this.size - 1));
        int i = this.size - 1;
        while (--i >= 0) {
            a = aggr.apply(a, f.apply(this.getQuick(i)));
        }
        return a;
    }

    public Object aggregate(ObjectMatrix1D other, ObjectObjectFunction aggr, ObjectObjectFunction f) {
        this.checkSize(other);
        if (this.size == 0) {
            return null;
        }
        Object a = f.apply(this.getQuick(this.size - 1), other.getQuick(this.size - 1));
        int i = this.size - 1;
        while (--i >= 0) {
            a = aggr.apply(a, f.apply(this.getQuick(i), other.getQuick(i)));
        }
        return a;
    }

    public ObjectMatrix1D assign(Object[] values) {
        if (values.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + values.length + ", size()=" + this.size());
        }
        int i = this.size;
        while (--i >= 0) {
            this.setQuick(i, values[i]);
        }
        return this;
    }

    public ObjectMatrix1D assign(ObjectFunction function) {
        int i = this.size;
        while (--i >= 0) {
            this.setQuick(i, function.apply(this.getQuick(i)));
        }
        return this;
    }

    public ObjectMatrix1D assign(ObjectMatrix1D other) {
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        if (this.haveSharedCells(other)) {
            other = other.copy();
        }
        int i = this.size;
        while (--i >= 0) {
            this.setQuick(i, other.getQuick(i));
        }
        return this;
    }

    public ObjectMatrix1D assign(ObjectMatrix1D y, ObjectObjectFunction function) {
        this.checkSize(y);
        int i = this.size;
        while (--i >= 0) {
            this.setQuick(i, function.apply(this.getQuick(i), y.getQuick(i)));
        }
        return this;
    }

    public ObjectMatrix1D assign(Object value) {
        int i = this.size;
        while (--i >= 0) {
            this.setQuick(i, value);
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int i = this.size;
        while (--i >= 0) {
            if (this.getQuick(i) == null) continue;
            ++cardinality;
        }
        return cardinality;
    }

    public ObjectMatrix1D copy() {
        ObjectMatrix1D copy = this.like();
        copy.assign(this);
        return copy;
    }

    public boolean equals(Object otherObj) {
        return this.equals(otherObj, true);
    }

    public boolean equals(Object otherObj, boolean testForEquality) {
        ObjectMatrix1D other;
        if (!(otherObj instanceof ObjectMatrix1D)) {
            return false;
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            // empty if block
        }
        if (this.size != (other = (ObjectMatrix1D)otherObj).size()) {
            return false;
        }
        if (!testForEquality) {
            int i = this.size;
            while (--i >= 0) {
                if (this.getQuick(i) == other.getQuick(i)) continue;
                return false;
            }
        } else {
            int i = this.size;
            while (--i >= 0) {
                if (!(this.getQuick(i) == null ? other.getQuick(i) != null : !this.getQuick(i).equals(other.getQuick(i)))) continue;
                return false;
            }
        }
        return true;
    }

    public Object get(int index) {
        if (index < 0 || index >= this.size) {
            this.checkIndex(index);
        }
        return this.getQuick(index);
    }

    protected ObjectMatrix1D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList indexList, ObjectArrayList valueList) {
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        int s = this.size;
        int i = 0;
        while (i < s) {
            Object value = this.getQuick(i);
            if (value != null) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
            }
            ++i;
        }
    }

    public abstract Object getQuick(int var1);

    protected boolean haveSharedCells(ObjectMatrix1D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix1D other) {
        return false;
    }

    public ObjectMatrix1D like() {
        return this.like(this.size);
    }

    public abstract ObjectMatrix1D like(int var1);

    public abstract ObjectMatrix2D like2D(int var1, int var2);

    public void set(int index, Object value) {
        if (index < 0 || index >= this.size) {
            this.checkIndex(index);
        }
        this.setQuick(index, value);
    }

    public abstract void setQuick(int var1, Object var2);

    public void swap(ObjectMatrix1D other) {
        this.checkSize(other);
        int i = this.size;
        while (--i >= 0) {
            Object tmp = this.getQuick(i);
            this.setQuick(i, other.getQuick(i));
            other.setQuick(i, tmp);
        }
    }

    public Object[] toArray() {
        Object[] values = new Object[this.size];
        this.toArray(values);
        return values;
    }

    public void toArray(Object[] values) {
        if (values.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        int i = this.size;
        while (--i >= 0) {
            values[i] = this.getQuick(i);
        }
    }

    public String toString() {
        return new Formatter().toString(this);
    }

    protected ObjectMatrix1D view() {
        return (ObjectMatrix1D)this.clone();
    }

    public ObjectMatrix1D viewFlip() {
        return (ObjectMatrix1D)this.view().vFlip();
    }

    public ObjectMatrix1D viewPart(int index, int width) {
        return (ObjectMatrix1D)this.view().vPart(index, width);
    }

    public ObjectMatrix1D viewSelection(int[] indexes) {
        if (indexes == null) {
            indexes = new int[this.size];
            int i = this.size;
            while (--i >= 0) {
                indexes[i] = i;
            }
        }
        this.checkIndexes(indexes);
        int[] offsets = new int[indexes.length];
        int i = indexes.length;
        while (--i >= 0) {
            offsets[i] = this.index(indexes[i]);
        }
        return this.viewSelectionLike(offsets);
    }

    public ObjectMatrix1D viewSelection(ObjectProcedure condition) {
        IntArrayList matches = new IntArrayList();
        int i = 0;
        while (i < this.size) {
            if (condition.apply(this.getQuick(i))) {
                matches.add(i);
            }
            ++i;
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements());
    }

    protected abstract ObjectMatrix1D viewSelectionLike(int[] var1);

    public ObjectMatrix1D viewSorted() {
        return Sorting.mergeSort.sort(this);
    }

    public ObjectMatrix1D viewStrides(int stride) {
        return (ObjectMatrix1D)this.view().vStrides(stride);
    }

    private boolean xforEach(ObjectProcedure procedure) {
        int i = this.size;
        while (--i >= 0) {
            if (procedure.apply(this.getQuick(i))) continue;
            return false;
        }
        return true;
    }
}

