/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import cern.colt.function.IntIntProcedure;
import cern.colt.function.IntProcedure;
import cern.colt.list.IntArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractIntIntMap
extends AbstractMap {
    protected AbstractIntIntMap() {
    }

    public boolean containsKey(final int key) {
        return !this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final int value) {
        return !this.forEachPair(new IntIntProcedure(){

            @Override
            public boolean apply(int iterKey, int iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractIntIntMap copy() {
        return (AbstractIntIntMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractIntIntMap)) {
            return false;
        }
        final AbstractIntIntMap other = (AbstractIntIntMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new IntIntProcedure(){

            @Override
            public boolean apply(int key, int value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new IntIntProcedure(){

            @Override
            public boolean apply(int key, int value) {
                return AbstractIntIntMap.this.containsKey(key) && AbstractIntIntMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(IntProcedure var1);

    public boolean forEachPair(final IntIntProcedure procedure) {
        return this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int key) {
                return procedure.apply(key, AbstractIntIntMap.this.get(key));
            }
        });
    }

    public abstract int get(int var1);

    public int keyOf(final int value) {
        final int[] foundKey = new int[1];
        boolean notFound = this.forEachPair(new IntIntProcedure(){

            @Override
            public boolean apply(int iterKey, int iterValue) {
                boolean found;
                boolean bl = found = value == iterValue;
                if (found) {
                    foundKey[0] = iterKey;
                }
                return !found;
            }
        });
        if (notFound) {
            return Integer.MIN_VALUE;
        }
        return foundKey[0];
    }

    public IntArrayList keys() {
        IntArrayList list = new IntArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final IntArrayList list) {
        list.clear();
        this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(IntArrayList keyList) {
        this.pairsSortedByValue(keyList, new IntArrayList(this.size()));
    }

    public void pairsMatching(final IntIntProcedure condition, final IntArrayList keyList, final IntArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new IntIntProcedure(){

            @Override
            public boolean apply(int key, int value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(IntArrayList keyList, IntArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(IntArrayList keyList, IntArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final int[] k = keyList.elements();
        final int[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                int t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                int t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(int var1, int var2);

    public abstract boolean removeKey(int var1);

    public String toString() {
        IntArrayList theKeys = this.keys();
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = theKeys.size() - 1;
        int i = 0;
        while (i <= maxIndex) {
            int key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i < maxIndex) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    public String toStringByValue() {
        IntArrayList theKeys = new IntArrayList();
        this.keysSortedByValue(theKeys);
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = theKeys.size() - 1;
        int i = 0;
        while (i <= maxIndex) {
            int key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i < maxIndex) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    public IntArrayList values() {
        IntArrayList list = new IntArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final IntArrayList list) {
        list.clear();
        this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int key) {
                list.add(AbstractIntIntMap.this.get(key));
                return true;
            }
        });
    }
}

