/*
 * Decompiled with CFR 0.152.
 */
package org.arabidopsis.ahocorasick;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.arabidopsis.ahocorasick.AhoCorasick;
import org.arabidopsis.ahocorasick.SearchResult;
import org.arabidopsis.ahocorasick.State;

public class TestAhoCorasick
extends TestCase {
    private AhoCorasick tree;

    public void setUp() {
        this.tree = new AhoCorasick();
    }

    public void testConstruction() {
        this.tree.add("hello".getBytes(), "hello".getBytes());
        this.tree.add("hi".getBytes(), "hi".getBytes());
        this.tree.prepare();
        State s0 = this.tree.getRoot();
        State s1 = s0.get((byte)104);
        State s2 = s1.get((byte)101);
        State s3 = s2.get((byte)108);
        State s4 = s3.get((byte)108);
        State s5 = s4.get((byte)111);
        State s6 = s1.get((byte)105);
        TestAhoCorasick.assertTrue((s6 != null ? 1 : 0) != 0);
        TestAhoCorasick.assertEquals(s0, s1.getFail());
        TestAhoCorasick.assertEquals(s0, s2.getFail());
        TestAhoCorasick.assertEquals(s0, s3.getFail());
        TestAhoCorasick.assertEquals(s0, s4.getFail());
        TestAhoCorasick.assertEquals(s0, s5.getFail());
        TestAhoCorasick.assertEquals(s0, s6.getFail());
        TestAhoCorasick.assertEquals((int)0, (int)s0.getOutputs().size());
        TestAhoCorasick.assertEquals((int)0, (int)s1.getOutputs().size());
        TestAhoCorasick.assertEquals((int)0, (int)s2.getOutputs().size());
        TestAhoCorasick.assertEquals((int)0, (int)s3.getOutputs().size());
        TestAhoCorasick.assertEquals((int)0, (int)s4.getOutputs().size());
        TestAhoCorasick.assertEquals((int)1, (int)s5.getOutputs().size());
        TestAhoCorasick.assertEquals((int)1, (int)s6.getOutputs().size());
    }

    public void testExample() {
        this.tree.add("he".getBytes(), "he".getBytes());
        this.tree.add("she".getBytes(), "she".getBytes());
        this.tree.add("his".getBytes(), "his".getBytes());
        this.tree.add("hers".getBytes(), "hers".getBytes());
        TestAhoCorasick.assertEquals((int)10, (int)this.tree.getRoot().size());
        this.tree.prepare();
        State s0 = this.tree.getRoot();
        State s1 = s0.get((byte)104);
        State s2 = s1.get((byte)101);
        State s3 = s0.get((byte)115);
        State s4 = s3.get((byte)104);
        State s5 = s4.get((byte)101);
        State s6 = s1.get((byte)105);
        State s7 = s6.get((byte)115);
        State s8 = s2.get((byte)114);
        State s9 = s8.get((byte)115);
        TestAhoCorasick.assertEquals(s0, s1.getFail());
        TestAhoCorasick.assertEquals(s0, s2.getFail());
        TestAhoCorasick.assertEquals(s0, s3.getFail());
        TestAhoCorasick.assertEquals(s0, s6.getFail());
        TestAhoCorasick.assertEquals(s0, s8.getFail());
        TestAhoCorasick.assertEquals(s1, s4.getFail());
        TestAhoCorasick.assertEquals(s2, s5.getFail());
        TestAhoCorasick.assertEquals(s3, s7.getFail());
        TestAhoCorasick.assertEquals(s3, s9.getFail());
        TestAhoCorasick.assertEquals((int)0, (int)s1.getOutputs().size());
        TestAhoCorasick.assertEquals((int)0, (int)s3.getOutputs().size());
        TestAhoCorasick.assertEquals((int)0, (int)s4.getOutputs().size());
        TestAhoCorasick.assertEquals((int)0, (int)s6.getOutputs().size());
        TestAhoCorasick.assertEquals((int)0, (int)s8.getOutputs().size());
        TestAhoCorasick.assertEquals((int)1, (int)s2.getOutputs().size());
        TestAhoCorasick.assertEquals((int)1, (int)s7.getOutputs().size());
        TestAhoCorasick.assertEquals((int)1, (int)s9.getOutputs().size());
        TestAhoCorasick.assertEquals((int)2, (int)s5.getOutputs().size());
    }

    public void testStartSearchWithSingleResult() {
        this.tree.add("apple".getBytes(), "apple".getBytes());
        this.tree.prepare();
        SearchResult result = this.tree.startSearch("washington cut the apple tree".getBytes());
        TestAhoCorasick.assertEquals((int)1, (int)result.getOutputs().size());
        TestAhoCorasick.assertEquals((String)"apple", (String)new String((byte[])result.getOutputs().iterator().next()));
        TestAhoCorasick.assertEquals((int)24, (int)result.getLastIndex());
        TestAhoCorasick.assertEquals(null, this.tree.continueSearch(result));
    }

    public void testStartSearchWithAdjacentResults() {
        this.tree.add("john".getBytes(), "john".getBytes());
        this.tree.add("jane".getBytes(), "jane".getBytes());
        this.tree.prepare();
        SearchResult firstResult = this.tree.startSearch("johnjane".getBytes());
        SearchResult secondResult = this.tree.continueSearch(firstResult);
        TestAhoCorasick.assertEquals(null, this.tree.continueSearch(secondResult));
    }

    public void testStartSearchOnEmpty() {
        this.tree.add("cipher".getBytes(), 0);
        this.tree.add("zip".getBytes(), 1);
        this.tree.add("nought".getBytes(), 2);
        this.tree.prepare();
        SearchResult result = this.tree.startSearch("".getBytes());
        TestAhoCorasick.assertEquals(null, result);
    }

    public void testMultipleOutputs() {
        this.tree.add("x".getBytes(), "x");
        this.tree.add("xx".getBytes(), "xx");
        this.tree.add("xxx".getBytes(), "xxx");
        this.tree.prepare();
        SearchResult result = this.tree.startSearch("xxx".getBytes());
        TestAhoCorasick.assertEquals((int)1, (int)result.getLastIndex());
        TestAhoCorasick.assertEquals(new HashSet<String>(Arrays.asList("x")), result.getOutputs());
        result = this.tree.continueSearch(result);
        TestAhoCorasick.assertEquals((int)2, (int)result.getLastIndex());
        TestAhoCorasick.assertEquals(new HashSet<String>(Arrays.asList("xx", "x")), result.getOutputs());
        result = this.tree.continueSearch(result);
        TestAhoCorasick.assertEquals((int)3, (int)result.getLastIndex());
        TestAhoCorasick.assertEquals(new HashSet<String>(Arrays.asList("xxx", "xx", "x")), result.getOutputs());
        TestAhoCorasick.assertEquals(null, this.tree.continueSearch(result));
    }

    public void testIteratorInterface() {
        this.tree.add("moo".getBytes(), "moo");
        this.tree.add("one".getBytes(), "one");
        this.tree.add("on".getBytes(), "on");
        this.tree.add("ne".getBytes(), "ne");
        this.tree.prepare();
        Iterator iter = this.tree.search("one moon ago".getBytes());
        TestAhoCorasick.assertTrue((boolean)iter.hasNext());
        SearchResult r = iter.next();
        TestAhoCorasick.assertEquals(new HashSet<String>(Arrays.asList("on")), r.getOutputs());
        TestAhoCorasick.assertEquals((int)2, (int)r.getLastIndex());
        TestAhoCorasick.assertTrue((boolean)iter.hasNext());
        r = iter.next();
        TestAhoCorasick.assertEquals(new HashSet<String>(Arrays.asList("one", "ne")), r.getOutputs());
        TestAhoCorasick.assertEquals((int)3, (int)r.getLastIndex());
        TestAhoCorasick.assertTrue((boolean)iter.hasNext());
        r = iter.next();
        TestAhoCorasick.assertEquals(new HashSet<String>(Arrays.asList("moo")), r.getOutputs());
        TestAhoCorasick.assertEquals((int)7, (int)r.getLastIndex());
        TestAhoCorasick.assertTrue((boolean)iter.hasNext());
        r = iter.next();
        TestAhoCorasick.assertEquals(new HashSet<String>(Arrays.asList("on")), r.getOutputs());
        TestAhoCorasick.assertEquals((int)8, (int)r.getLastIndex());
        TestAhoCorasick.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            TestAhoCorasick.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void largerTextExample() {
        String text = "The ga3 mutant of Arabidopsis is a gibberellin-responsive dwarf. We present data showing that the ga3-1 mutant is deficient in ent-kaurene oxidase activity, the first cytochrome P450-mediated step in the gibberellin biosynthetic pathway. By using a combination of conventional map-based cloning and random sequencing we identified a putative cytochrome P450 gene mapping to the same location as GA3. Relative to the progenitor line, two ga3 mutant alleles contained single base changes generating in-frame stop codons in the predicted amino acid sequence of the P450. A genomic clone spanning the P450 locus complemented the ga3-2 mutant. The deduced GA3 protein defines an additional class of cytochrome P450 enzymes. The GA3 gene was expressed in all tissues examined, RNA abundance being highest in inflorescence tissue.";
        String[] terms = new String[]{"microsome", "cytochrome", "cytochrome P450 activity", "gibberellic acid biosynthesis", "GA3", "cytochrome P450", "oxygen binding", "AT5G25900.1", "protein", "RNA", "gibberellin", "Arabidopsis", "ent-kaurene oxidase activity", "inflorescence", "tissue"};
        for (int i = 0; i < terms.length; ++i) {
            this.tree.add(terms[i].getBytes(), terms[i]);
        }
        this.tree.prepare();
        HashSet termsThatHit = new HashSet();
        Iterator iter = this.tree.search(text.getBytes());
        while (iter.hasNext()) {
            SearchResult result = iter.next();
            termsThatHit.addAll(result.getOutputs());
        }
        TestAhoCorasick.assertEquals(new HashSet<String>(Arrays.asList("cytochrome", "GA3", "cytochrome P450", "protein", "RNA", "gibberellin", "Arabidopsis", "ent-kaurene oxidase activity", "inflorescence", "tissue")), termsThatHit);
    }
}

