/*
 * Decompiled with CFR 0.152.
 */
package org.arabidopsis.ahocorasick;

import org.arabidopsis.ahocorasick.EdgeList;
import org.arabidopsis.ahocorasick.State;

class SparseEdgeList<T>
implements EdgeList<T> {
    private Cons<T> head = null;

    @Override
    public State<T> get(byte b) {
        Cons<T> c = this.head;
        while (c != null) {
            if (c.b == b) {
                return c.s;
            }
            c = c.next;
        }
        return null;
    }

    @Override
    public void put(byte b, State<T> s) {
        this.head = new Cons<T>(b, s, this.head);
    }

    @Override
    public byte[] keys() {
        int length = 0;
        Cons<T> c = this.head;
        while (c != null) {
            ++length;
            c = c.next;
        }
        byte[] result = new byte[length];
        c = this.head;
        int j = 0;
        while (c != null) {
            result[j] = c.b;
            ++j;
            c = c.next;
        }
        return result;
    }

    private static class Cons<T> {
        byte b;
        State<T> s;
        Cons<T> next;

        public Cons(byte b, State<T> s, Cons<T> next) {
            this.b = b;
            this.s = s;
            this.next = next;
        }
    }
}

