/*
 * Decompiled with CFR 0.152.
 */
package org.arabidopsis.ahocorasick;

import org.arabidopsis.ahocorasick.EdgeList;
import org.arabidopsis.ahocorasick.SparseEdgeList;
import org.arabidopsis.ahocorasick.State;

class DenseEdgeList<T>
implements EdgeList<T> {
    private State<T>[] array = new State[256];

    public DenseEdgeList() {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = null;
        }
    }

    public static <T> DenseEdgeList<T> fromSparse(SparseEdgeList<T> list) {
        byte[] keys = list.keys();
        DenseEdgeList<T> newInstance = new DenseEdgeList<T>();
        for (int i = 0; i < keys.length; ++i) {
            newInstance.put(keys[i], list.get(keys[i]));
        }
        return newInstance;
    }

    @Override
    public State<T> get(byte b) {
        return this.array[b & 0xFF];
    }

    @Override
    public void put(byte b, State<T> s) {
        this.array[b & 0xFF] = s;
    }

    @Override
    public byte[] keys() {
        int length = 0;
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            ++length;
        }
        byte[] result = new byte[length];
        int j = 0;
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            result[j] = (byte)i;
            ++j;
        }
        return result;
    }
}

