/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.annotation.evaluation.datasets.cifar;

import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.annotation.evaluation.datasets.cifar.BinaryReader;
import org.openimaj.image.colour.ColourSpace;

public class MBFImageReader
implements BinaryReader<MBFImage> {
    int width;
    int height;

    public MBFImageReader(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public MBFImage read(byte[] record) {
        MBFImage image = new MBFImage(this.width, this.height, ColourSpace.RGB);
        float[][] r = ((FImage)image.getBand((int)0)).pixels;
        float[][] g = ((FImage)image.getBand((int)1)).pixels;
        float[][] b = ((FImage)image.getBand((int)2)).pixels;
        int j = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                r[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[record[j] & 0xFF];
                g[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[record[j + this.height * this.width] & 0xFF];
                b[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[record[j + 2 * this.height * this.width] & 0xFF];
                ++x;
                ++j;
            }
        }
        return image;
    }
}

