/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.annotation.evaluation.datasets.cifar;

import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.annotation.evaluation.datasets.cifar.BinaryReader;

public class FImageReader
implements BinaryReader<FImage> {
    int width;
    int height;

    public FImageReader(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public final FImage read(byte[] record) {
        FImage image = new FImage(this.width, this.height);
        float[][] p = image.pixels;
        int j = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                float r = ImageUtilities.BYTE_TO_FLOAT_LUT[record[j] & 0xFF];
                float g = ImageUtilities.BYTE_TO_FLOAT_LUT[record[j] & 0xFF];
                float b = ImageUtilities.BYTE_TO_FLOAT_LUT[record[j] & 0xFF];
                p[y][x] = (r + g + b) / 3.0f;
                ++x;
                ++j;
            }
        }
        return image;
    }
}

