/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.annotation.evaluation.datasets;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.experiment.annotations.DatasetDescription;
import org.openimaj.experiment.evaluation.agreement.CohensKappaInterraterAgreement;
import org.openimaj.experiment.evaluation.agreement.MajorityVoting;
import org.openimaj.ml.annotation.ScoredAnnotation;
import org.openimaj.util.iterator.TextLineIterable;
import org.openimaj.web.flickr.FlickrImage;

@Reference(type=ReferenceType.Inproceedings, author={"Loni, Babak", "Menendez, Maria", "Georgescu, Mihai", "Galli, Luca", "Massari, Claudio", "Altingovde, Ismail Sengor", "Martinenghi, Davide", "Melenhorst, Mark", "Vliegendhart, Raynor", "Larson, Martha"}, title="Fashion-focused creative commons social dataset", year="2013", booktitle="Proceedings of the 4th ACM Multimedia Systems Conference", pages={"72", "", "77"}, url="http://doi.acm.org/10.1145/2483977.2483984", publisher="ACM", series="MMSys '13", customData={"isbn", "978-1-4503-1894-5", "location", "Oslo, Norway", "numpages", "6", "doi", "10.1145/2483977.2483984", "acmid", "2483984", "address", "New York, NY, USA", "keywords", "crowdsourcing, dataset, fashion, multimedia content analysis"})
@DatasetDescription(name="Fashion-Focused Creative Commons Social Dataset", description="a fashion-focused Creative Commons dataset, which is designed to contain a mix of general images as well as a large component of images that are focused on fashion (i.e., relevant to particular clothing items or fashion accessories)", creator="Babak Loni, Maria Menendez, Mihai Georgescu, Luca Galli, Claudio Massari, Ismail Sengor Altingovde, Davide Martinenghi, Mark Melenhorst, Raynor Vliegendhart, Martha Larson", downloadUrls={"http://skuld.cs.umass.edu/traces/mmsys/2013/fashion/Fashion Dataset.zip"})
public class MMSys2013 {
    protected String baseLocation = "/data/degas/mediaeval/mediaeval-crowdsourcing/MMSys2013/";
    protected String expertDataFile = "Annotations/Annotation_PerImage_Trusted.csv";
    protected String nonExpertDataFile = "Annotations/Annotation_PerImage_NonExperts.csv";
    protected String groundTruthFile = "Annotations/GroundTruth.csv";
    protected String queriesFile = "Metadata/queries.csv";

    public GroupedDataset<String, GroupedDataset<String, ListDataset<Response>, Response>, Response> getGroundTruth() {
        String[] parts;
        MapBackedDataset results = new MapBackedDataset();
        HashMap<Long, String> categoryCache = new HashMap<Long, String>();
        boolean firstLine = true;
        for (String line : new TextLineIterable(new File(this.baseLocation, this.queriesFile))) {
            if (!firstLine) {
                parts = line.split(",", -1);
                categoryCache.put(Long.parseLong(parts[3].substring(1).substring(0, parts[3].length() - 2)), parts[0].substring(1).substring(0, parts[0].length() - 2));
            }
            firstLine = false;
        }
        firstLine = true;
        for (String line : new TextLineIterable(new File(this.baseLocation, this.groundTruthFile))) {
            if (!firstLine) {
                try {
                    ListDataset ids;
                    parts = line.split(",", -1);
                    String url = parts[0];
                    FlickrImage fi = FlickrImage.create((URL)new URL(url));
                    String cat = (String)categoryCache.get(fi.getId());
                    GroupedDataset gds = (GroupedDataset)results.get((Object)cat);
                    if (gds == null) {
                        gds = new MapBackedDataset();
                        results.put((Object)cat, (Object)gds);
                    }
                    if ((ids = (ListDataset)gds.get((Object)url)) == null) {
                        ids = new ListBackedDataset();
                        gds.put((Object)url, (Object)ids);
                    }
                    Response rr = new Response(this.parseQR(parts[1]), this.parseQR(parts[2]), 1);
                    ids.add((Object)rr);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            firstLine = false;
        }
        return results;
    }

    public GroupedDataset<String, GroupedDataset<String, ListDataset<Response>, Response>, Response> getNonExpertData() {
        return this.parseMetadata(new File(this.baseLocation, this.nonExpertDataFile));
    }

    public GroupedDataset<String, GroupedDataset<String, ListDataset<Response>, Response>, Response> getExpertData() {
        return this.parseMetadata(new File(this.baseLocation, this.expertDataFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupedDataset<String, GroupedDataset<String, ListDataset<Response>, Response>, Response> parseMetadata(File metadataFile) {
        MapBackedDataset results = new MapBackedDataset();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(metadataFile));
            boolean firstLine = true;
            int count = 1;
            while ((line = br.readLine()) != null) {
                if (!firstLine) {
                    try {
                        ListDataset ids;
                        String[] parts = line.split(",", -1);
                        Response[] r = new Response[]{new Response(this.parseQR(parts[3]), this.parseQR(parts[6]), this.parseF(parts[9])), new Response(this.parseQR(parts[4]), this.parseQR(parts[7]), this.parseF(parts[10])), new Response(this.parseQR(parts[5]), this.parseQR(parts[8]), parts.length > 11 ? this.parseF(parts[11]) : -1)};
                        GroupedDataset gds = (GroupedDataset)results.get((Object)parts[2]);
                        if (gds == null) {
                            gds = new MapBackedDataset();
                            results.put((Object)parts[2], (Object)gds);
                        }
                        if ((ids = (ListDataset)gds.get((Object)parts[1])) == null) {
                            ids = new ListBackedDataset();
                            gds.put((Object)parts[1], (Object)ids);
                        }
                        for (Response rr : r) {
                            ids.add((Object)rr);
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Error on line " + count);
                        e.printStackTrace();
                    }
                }
                firstLine = false;
                ++count;
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return results;
    }

    protected QuestionResponse parseQR(String qr) {
        if (qr.toLowerCase().equals("yes")) {
            return QuestionResponse.YES;
        }
        if (qr.toLowerCase().equals("no")) {
            return QuestionResponse.NO;
        }
        if (qr.toLowerCase().equals("notsure")) {
            return QuestionResponse.NOT_SURE;
        }
        return QuestionResponse.UNANSWERED;
    }

    protected int parseF(String f) {
        try {
            return Integer.parseInt(f);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static Map<String, List<ScoredAnnotation<QuestionResponse>>> getAnnotationsQ1(GroupedDataset<String, ListDataset<Response>, Response> data) {
        HashMap<String, List<ScoredAnnotation<QuestionResponse>>> r = new HashMap<String, List<ScoredAnnotation<QuestionResponse>>>();
        for (String imgUrl : data.getGroups()) {
            ListDataset l = (ListDataset)data.get((Object)imgUrl);
            ArrayList<ScoredAnnotation> l2 = new ArrayList<ScoredAnnotation>();
            r.put(imgUrl, l2);
            for (Response rr : l) {
                l2.add(new ScoredAnnotation((Object)rr.containsCategoryDepiction, (float)rr.familiarityWithCategory));
            }
        }
        return r;
    }

    public static Map<String, List<ScoredAnnotation<QuestionResponse>>> getAnnotationsQ2(GroupedDataset<String, ListDataset<Response>, Response> data) {
        HashMap<String, List<ScoredAnnotation<QuestionResponse>>> r = new HashMap<String, List<ScoredAnnotation<QuestionResponse>>>();
        for (String imgUrl : data.getGroups()) {
            ListDataset l = (ListDataset)data.get((Object)imgUrl);
            ArrayList<ScoredAnnotation> l2 = new ArrayList<ScoredAnnotation>();
            r.put(imgUrl, l2);
            for (Response rr : l) {
                l2.add(new ScoredAnnotation((Object)rr.isInCorrectCategory, (float)rr.familiarityWithCategory));
            }
        }
        return r;
    }

    public static void main(String[] args) {
        System.out.println();
        Map<String, List<ScoredAnnotation<QuestionResponse>>> q1r1 = MMSys2013.getAnnotationsQ1((GroupedDataset<String, ListDataset<Response>, Response>)((GroupedDataset)new MMSys2013().getExpertData().get((Object)"Cowboy hat")));
        Map<String, List<ScoredAnnotation<QuestionResponse>>> q2r1 = MMSys2013.getAnnotationsQ2((GroupedDataset<String, ListDataset<Response>, Response>)((GroupedDataset)new MMSys2013().getExpertData().get((Object)"Cowboy hat")));
        Map<String, List<ScoredAnnotation<QuestionResponse>>> q1r2 = MMSys2013.getAnnotationsQ1((GroupedDataset<String, ListDataset<Response>, Response>)((GroupedDataset)new MMSys2013().getNonExpertData().get((Object)"Cowboy hat")));
        Map<String, List<ScoredAnnotation<QuestionResponse>>> q2r2 = MMSys2013.getAnnotationsQ2((GroupedDataset<String, ListDataset<Response>, Response>)((GroupedDataset)new MMSys2013().getNonExpertData().get((Object)"Cowboy hat")));
        Map<String, List<ScoredAnnotation<QuestionResponse>>> q1gt = MMSys2013.getAnnotationsQ1((GroupedDataset<String, ListDataset<Response>, Response>)((GroupedDataset)new MMSys2013().getGroundTruth().get((Object)"Cowboy hat")));
        Map<String, List<ScoredAnnotation<QuestionResponse>>> q2gt = MMSys2013.getAnnotationsQ2((GroupedDataset<String, ListDataset<Response>, Response>)((GroupedDataset)new MMSys2013().getGroundTruth().get((Object)"Cowboy hat")));
        Map q1r1mv = MajorityVoting.calculateBasicMajorityVote(q1r1);
        Map q2r1mv = MajorityVoting.calculateBasicMajorityVote(q2r1);
        Map q1r2mv = MajorityVoting.calculateBasicMajorityVote(q1r2);
        Map q2r2mv = MajorityVoting.calculateBasicMajorityVote(q2r2);
        Map q1gtmv = MajorityVoting.calculateBasicMajorityVote(q1gt);
        Map q2gtmv = MajorityVoting.calculateBasicMajorityVote(q2gt);
        System.out.println("Question 1 agreement between raters 1 and 2: " + CohensKappaInterraterAgreement.calculate((Map)q1r1mv, (Map)q1r2mv));
        System.out.println("Question 1 agreement between rater 1 and GT: " + CohensKappaInterraterAgreement.calculate((Map)q1r1mv, (Map)q1gtmv));
        System.out.println("Question 1 agreement between rater 2 and GT: " + CohensKappaInterraterAgreement.calculate((Map)q1r2mv, (Map)q1gtmv));
        System.out.println("Question 2 agreement between raters 1 and 2: " + CohensKappaInterraterAgreement.calculate((Map)q2r1mv, (Map)q2r2mv));
        System.out.println("Question 2 agreement between rater 1 and GT: " + CohensKappaInterraterAgreement.calculate((Map)q2r1mv, (Map)q2gtmv));
        System.out.println("Question 2 agreement between rater 2 and GT: " + CohensKappaInterraterAgreement.calculate((Map)q2r2mv, (Map)q2gtmv));
    }

    protected static class Record {
        public FlickrImage image;
        public String category;
        public Response[] annotations;

        protected Record() {
        }

        public String toString() {
            return this.image.getId() + ":" + this.category + "[" + Arrays.toString(this.annotations) + "]";
        }
    }

    public static class Response {
        public QuestionResponse containsCategoryDepiction;
        public QuestionResponse isInCorrectCategory;
        public int familiarityWithCategory;

        public Response(QuestionResponse r1, QuestionResponse r2, int familiarity) {
            this.containsCategoryDepiction = r1;
            this.isInCorrectCategory = r2;
            this.familiarityWithCategory = familiarity;
        }

        public String toString() {
            return "{" + (Object)((Object)this.containsCategoryDepiction) + "," + (Object)((Object)this.isInCorrectCategory) + "," + this.familiarityWithCategory + "}";
        }
    }

    public static enum QuestionResponse {
        NO,
        YES,
        NOT_SURE,
        UNANSWERED;

    }
}

