/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.annotation.evaluation.datasets;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.data.DataUtils;
import org.openimaj.data.dataset.Dataset;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.experiment.annotations.DatasetDescription;
import org.openimaj.image.annotation.evaluation.datasets.CIFARDataset;
import org.openimaj.image.annotation.evaluation.datasets.cifar.BinaryReader;

@Reference(type=ReferenceType.Article, author={"Krizhevsky, A.", "Hinton, G."}, title="Learning multiple layers of features from tiny images", year="2009", journal="Master's thesis, Department of Computer Science, University of Toronto", publisher="Citeseer")
@DatasetDescription(name="CIFAR-10", description="The CIFAR-10 dataset consists of 60000 32x32 colour images in 10 classes, with 6000 images per class. There are 50000 training images and 10000 test images. The dataset is divided into five training batches and one test batch, each with 10000 images. The test batch contains exactly 1000 randomly-selected images from each class. The training batches contain the remaining images in random order, but some training batches may contain more images from one class than another. Between them, the training batches contain exactly 5000 images from each class.", creator="Alex Krizhevsky, Vinod Nair, and Geoffrey Hinton", url="http://www.cs.toronto.edu/~kriz/cifar.html", downloadUrls={"http://datasets.openimaj.org/cifar/cifar-10-binary.tar.gz"})
public class CIFAR10Dataset
extends CIFARDataset {
    private static final String DATA_TGZ = "cifar/cifar-10-binary.tar.gz";
    private static final String DOWNLOAD_URL = "http://datasets.openimaj.org/cifar/cifar-10-binary.tar.gz";
    private static final String[] TRAINING_FILES = new String[]{"data_batch_1.bin", "data_batch_2.bin", "data_batch_3.bin", "data_batch_4.bin", "data_batch_5.bin"};
    private static final String TEST_FILE = "test_batch.bin";
    private static final String CLASSES_FILE = "batches.meta.txt";

    private CIFAR10Dataset() {
    }

    private static String downloadAndGetPath() throws IOException {
        File dataset = DataUtils.getDataLocation((String)DATA_TGZ);
        if (!dataset.exists()) {
            dataset.getParentFile().mkdirs();
            FileUtils.copyURLToFile((URL)new URL(DOWNLOAD_URL), (File)dataset);
        }
        return "tgz:file:" + dataset.toString() + "!cifar-10-batches-bin/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <IMAGE> GroupedDataset<String, ListDataset<IMAGE>, IMAGE> getTrainingImages(BinaryReader<IMAGE> reader) throws IOException {
        MapBackedDataset dataset = new MapBackedDataset();
        FileSystemManager fsManager = VFS.getManager();
        FileObject base = fsManager.resolveFile(CIFAR10Dataset.downloadAndGetPath());
        List<String> classList = CIFAR10Dataset.loadClasses(dataset, base);
        for (String t : TRAINING_FILES) {
            DataInputStream is = null;
            try {
                is = new DataInputStream(base.resolveFile(t).getContent().getInputStream());
                CIFAR10Dataset.loadData(is, dataset, classList, reader);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <IMAGE> List<String> loadClasses(MapBackedDataset<String, ListDataset<IMAGE>, IMAGE> dataset, FileObject base) throws FileSystemException, IOException {
        InputStream classStream = null;
        List classList = null;
        try {
            classStream = base.resolveFile(CLASSES_FILE).getContent().getInputStream();
            classList = IOUtils.readLines((InputStream)classStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(classStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)classStream);
        for (String clz : classList) {
            dataset.put((Object)clz, (Dataset)new ListBackedDataset());
        }
        return classList;
    }

    private static <IMAGE> void loadData(DataInputStream is, MapBackedDataset<String, ListDataset<IMAGE>, IMAGE> dataset, List<String> classList, BinaryReader<IMAGE> reader) throws IOException {
        for (int i = 0; i < 10000; ++i) {
            int clz = is.read();
            String clzStr = classList.get(clz);
            byte[] record = new byte[3072];
            is.readFully(record);
            ((ListDataset)dataset.get((Object)clzStr)).add(reader.read(record));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <IMAGE> GroupedDataset<String, ListDataset<IMAGE>, IMAGE> getTestImages(BinaryReader<IMAGE> reader) throws IOException {
        MapBackedDataset dataset = new MapBackedDataset();
        FileSystemManager fsManager = VFS.getManager();
        FileObject base = fsManager.resolveFile(CIFAR10Dataset.downloadAndGetPath());
        List<String> classList = CIFAR10Dataset.loadClasses(dataset, base);
        DataInputStream is = null;
        try {
            is = new DataInputStream(base.resolveFile(TEST_FILE).getContent().getInputStream());
            CIFAR10Dataset.loadData(is, dataset, classList, reader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return dataset;
    }
}

