/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.annotation.evaluation.dataset;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import net.sf.jasperreports.engine.JRException;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.experiment.dataset.util.DatasetAdaptors;
import org.openimaj.experiment.evaluation.retrieval.RetrievalAnalyser;
import org.openimaj.experiment.evaluation.retrieval.RetrievalEvaluator;
import org.openimaj.experiment.evaluation.retrieval.analysers.IREvalAnalyser;
import org.openimaj.experiment.evaluation.retrieval.analysers.IREvalResult;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.image.annotation.evaluation.dataset.CorelAnnotatedImage;
import org.openimaj.image.annotation.evaluation.dataset.ImageWrapper;
import org.openimaj.image.annotation.evaluation.dataset.StandardCorel5kSplit;
import org.openimaj.ml.annotation.Annotator;
import org.openimaj.ml.annotation.evaluation.AnnotationEvaluator;
import org.openimaj.ml.annotation.linear.DenseLinearTransformAnnotator;

public class Corel5kDataset
extends ListBackedDataset<CorelAnnotatedImage> {
    File baseDir = new File("/Users/jsh2/Data/corel-5k");
    File imageDir = new File(this.baseDir, "images");
    File metaDir = new File(this.baseDir, "metadata");

    public Corel5kDataset() throws IOException {
        for (File f : this.imageDir.listFiles()) {
            if (!f.getName().endsWith(".jpeg")) continue;
            String id = f.getName().replace(".jpeg", "");
            this.data.add(new CorelAnnotatedImage(id, f, new File(this.metaDir, id + "_1.txt")));
        }
    }

    public static void main(String[] args) throws IOException, JRException {
        Corel5kDataset alldata = new Corel5kDataset();
        StandardCorel5kSplit split = new StandardCorel5kSplit();
        split.split(alldata);
        ListDataset<CorelAnnotatedImage> training = split.getTrainingDataset();
        DenseLinearTransformAnnotator ann = new DenseLinearTransformAnnotator(315, (FeatureExtractor)new HistogramExtractor());
        ann.train(DatasetAdaptors.asList(training));
        AnnotationEvaluator eval = new AnnotationEvaluator((Annotator)ann, split.getTestDataset());
        RetrievalEvaluator retEval = eval.newRetrievalEvaluator((RetrievalAnalyser)new IREvalAnalyser());
        Map retRes = retEval.evaluate();
        IREvalResult retAnalysis = (IREvalResult)retEval.analyse(retRes);
        System.out.println(retAnalysis);
    }

    public static class HistogramExtractor
    implements FeatureExtractor<DoubleFV, ImageWrapper> {
        Map<String, DoubleFV> data = new HashMap<String, DoubleFV>();

        public HistogramExtractor() throws IOException {
            String line;
            BufferedReader br = new BufferedReader(new FileReader("/Users/jsh2/Data/corel-5k/BLOBS_data.txt"));
            while ((line = br.readLine()) != null) {
                Scanner sc = new Scanner(line);
                String id = sc.nextInt() + "";
                double[] vec = new double[500];
                while (sc.hasNext()) {
                    String token = sc.next();
                    double weight = Double.parseDouble(sc.next().replace(",", ""));
                    if (!token.startsWith("blob")) continue;
                    int blobId = Integer.parseInt(token.replace("blob[", "").replace("]", ""));
                    int n = blobId - 1;
                    vec[n] = vec[n] + weight;
                }
                sc.close();
                this.data.put(id, new DoubleFV(vec));
            }
            br.close();
        }

        public DoubleFV extractFeature(ImageWrapper object) {
            return this.data.get(object.getID());
        }
    }
}

