/*
 * Decompiled with CFR 0.152.
 */
package org.lemurproject.ireval;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.lemurproject.ireval.IREval;
import org.lemurproject.ireval.RetrievalEvaluator;

public class SetRetrievalEvaluator {
    Collection<RetrievalEvaluator> _evaluators;

    public SetRetrievalEvaluator(Collection<RetrievalEvaluator> evaluators) {
        this._evaluators = evaluators;
    }

    public Collection<RetrievalEvaluator> getEvaluators() {
        return this._evaluators;
    }

    public static int[] getFixedPoints() {
        return RetrievalEvaluator.getFixedPoints();
    }

    public double[] precisionAtFixedPoints() {
        int[] fixedPoints = RetrievalEvaluator.getFixedPoints();
        double[] retVal = new double[fixedPoints.length];
        int i = 0;
        for (int point : fixedPoints) {
            retVal[i++] = this.meanPrecision(point);
        }
        return retVal;
    }

    public double[] interpolatedPrecision() {
        double[] precs = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        for (RetrievalEvaluator evaluator : this._evaluators) {
            double[] vals = evaluator.interpolatedPrecision();
            for (int j = 0; j < vals.length; ++j) {
                int n = j;
                precs[n] = precs[n] + vals[j];
            }
        }
        int j = 0;
        while (j < precs.length) {
            int n = j++;
            precs[n] = precs[n] / (double)this._evaluators.size();
        }
        return precs;
    }

    public double meanAveragePrecision() {
        double sumAveragePrecision = 0.0;
        if (this._evaluators.size() == 0) {
            return 0.0;
        }
        for (RetrievalEvaluator evaluator : this._evaluators) {
            sumAveragePrecision += evaluator.averagePrecision();
        }
        return sumAveragePrecision / (double)this._evaluators.size();
    }

    public double meanBinaryPreference() {
        double sumBinaryPreference = 0.0;
        if (this._evaluators.size() == 0) {
            return 0.0;
        }
        for (RetrievalEvaluator evaluator : this._evaluators) {
            sumBinaryPreference += evaluator.binaryPreference();
        }
        return sumBinaryPreference / (double)this._evaluators.size();
    }

    public double geometricMeanAveragePrecision() {
        double productAveragePrecision = 1.0;
        if (this._evaluators.size() == 0) {
            return 0.0;
        }
        for (RetrievalEvaluator evaluator : this._evaluators) {
            double p = evaluator.averagePrecision();
            if (!(p > 0.0)) continue;
            productAveragePrecision *= p;
        }
        return Math.pow(productAveragePrecision, 1.0 / (double)this._evaluators.size());
    }

    public double meanPrecision(int documentsRetrieved) {
        double sumPrecision = 0.0;
        if (this._evaluators.size() == 0) {
            return 0.0;
        }
        for (RetrievalEvaluator evaluator : this._evaluators) {
            sumPrecision += evaluator.precision(documentsRetrieved);
        }
        return sumPrecision / (double)this._evaluators.size();
    }

    public double meanReciprocalRank() {
        double sumRR = 0.0;
        if (this._evaluators.size() == 0) {
            return 0.0;
        }
        for (RetrievalEvaluator evaluator : this._evaluators) {
            sumRR += evaluator.reciprocalRank();
        }
        return sumRR / (double)this._evaluators.size();
    }

    public double meanRPrecision() {
        double sumRPrecision = 0.0;
        if (this._evaluators.size() == 0) {
            return 0.0;
        }
        for (RetrievalEvaluator evaluator : this._evaluators) {
            sumRPrecision += evaluator.rPrecision();
        }
        return sumRPrecision / (double)this._evaluators.size();
    }

    public double meanNormalizedDiscountedCumulativeGain() {
        double sumNDCG = 0.0;
        if (this._evaluators.size() == 0) {
            return 0.0;
        }
        for (RetrievalEvaluator evaluator : this._evaluators) {
            sumNDCG += evaluator.normalizedDiscountedCumulativeGain();
        }
        return sumNDCG / (double)this._evaluators.size();
    }

    public double meanNormalizedDiscountedCumulativeGain(int documentsRetrieved) {
        double sumNDCG = 0.0;
        if (this._evaluators.size() == 0) {
            return 0.0;
        }
        for (RetrievalEvaluator evaluator : this._evaluators) {
            sumNDCG += evaluator.normalizedDiscountedCumulativeGain(documentsRetrieved);
        }
        return sumNDCG / (double)this._evaluators.size();
    }

    public Map<String, Double> evaluateAll(String metric) throws IllegalArgumentException {
        TreeMap<String, Double> result = new TreeMap<String, Double>();
        for (RetrievalEvaluator evaluator : this._evaluators) {
            double value = 0.0;
            if (metric.equals("averagePrecision") || metric.equals("ap") || metric.equals("map")) {
                value = evaluator.averagePrecision();
            } else if (metric.equals("ndcg")) {
                value = evaluator.normalizedDiscountedCumulativeGain();
            } else if (metric.equals("reciprocalRank") || metric.equals("mrr")) {
                value = evaluator.reciprocalRank();
            } else if (metric.equals("rPrecision")) {
                value = evaluator.rPrecision();
            } else if (metric.equals("bpref")) {
                value = evaluator.binaryPreference();
            } else if (metric.startsWith("P")) {
                value = evaluator.precision(Integer.parseInt(metric.substring(1)));
            } else if (metric.startsWith("R")) {
                value = evaluator.recall(Integer.parseInt(metric.substring(1)));
            } else {
                throw new IllegalArgumentException("Unknown metric: " + metric);
            }
            result.put(evaluator.queryName(), value);
        }
        return result;
    }

    public int numberRetrieved() {
        int sumRetrieved = 0;
        for (RetrievalEvaluator evaluator : this._evaluators) {
            sumRetrieved += evaluator.retrievedDocuments().size();
        }
        return sumRetrieved;
    }

    public int numberRelevant() {
        int sumRelevant = 0;
        for (RetrievalEvaluator evaluator : this._evaluators) {
            sumRelevant += evaluator.relevantDocuments().size();
        }
        return sumRelevant;
    }

    public int numberRelevantRetrieved() {
        int sumRelevantRetrieved = 0;
        for (RetrievalEvaluator evaluator : this._evaluators) {
            sumRelevantRetrieved += evaluator.relevantRetrievedDocuments().size();
        }
        return sumRelevantRetrieved;
    }

    public String toString() {
        return IREval.singleEvaluation(this, true);
    }
}

