/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;

public class GivensRotation {
    private final double c;
    private final double s;

    public GivensRotation(double x, double y) {
        double roe = Math.abs(x) > Math.abs(y) ? x : y;
        double scale = Math.abs(x) + Math.abs(y);
        if (scale != 0.0) {
            double xs = x / scale;
            double ys = y / scale;
            double r = scale * Math.sqrt(xs * xs + ys * ys);
            if (roe < 0.0) {
                r *= -1.0;
            }
            this.c = x / r;
            this.s = y / r;
        } else {
            this.c = 1.0;
            this.s = 0.0;
        }
    }

    public void apply(Matrix H, int column, int i1, int i2) {
        double temp = this.c * H.get(i1, column) + this.s * H.get(i2, column);
        H.set(i2, column, -this.s * H.get(i1, column) + this.c * H.get(i2, column));
        H.set(i1, column, temp);
    }

    public void apply(Vector x, int i1, int i2) {
        double temp = this.c * x.get(i1) + this.s * x.get(i2);
        x.set(i2, -this.s * x.get(i1) + this.c * x.get(i2));
        x.set(i1, temp);
    }
}

