/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.recognition.benchmarking;

import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.experiment.ExperimentContext;
import org.openimaj.experiment.RunnableExperiment;
import org.openimaj.experiment.annotations.DependentVariable;
import org.openimaj.experiment.annotations.Experiment;
import org.openimaj.experiment.annotations.IndependentVariable;
import org.openimaj.experiment.annotations.Time;
import org.openimaj.experiment.evaluation.ResultAggregator;
import org.openimaj.experiment.evaluation.classification.ClassificationAnalyser;
import org.openimaj.experiment.evaluation.classification.ClassificationEvaluator;
import org.openimaj.experiment.evaluation.classification.analysers.confusionmatrix.AggregatedCMResult;
import org.openimaj.experiment.evaluation.classification.analysers.confusionmatrix.CMAggregator;
import org.openimaj.experiment.evaluation.classification.analysers.confusionmatrix.CMAnalyser;
import org.openimaj.experiment.evaluation.classification.analysers.confusionmatrix.CMResult;
import org.openimaj.experiment.validation.ValidationOperation;
import org.openimaj.experiment.validation.ValidationRunner;
import org.openimaj.experiment.validation.cross.CrossValidator;
import org.openimaj.image.Image;
import org.openimaj.image.processing.face.detection.DatasetFaceDetector;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.detection.FaceDetector;
import org.openimaj.image.processing.face.recognition.FaceRecogniser;
import org.openimaj.image.processing.face.recognition.benchmarking.FaceRecogniserProvider;

@Experiment(author="Jonathon Hare", dateCreated="2012-07-26", description="Face recognition cross validation experiment")
public class CrossValidationBenchmark<PERSON, IMAGE extends Image<?, IMAGE>, FACE extends DetectedFace>
implements RunnableExperiment {
    @IndependentVariable
    protected CrossValidator<GroupedDataset<PERSON, ListDataset<FACE>, FACE>> crossValidator;
    @IndependentVariable
    protected GroupedDataset<PERSON, ? extends ListDataset<IMAGE>, IMAGE> dataset;
    @IndependentVariable
    protected FaceDetector<FACE, IMAGE> faceDetector;
    @IndependentVariable
    protected FaceRecogniserProvider<FACE, PERSON> engine;
    @DependentVariable
    protected AggregatedCMResult<PERSON> result;

    public CrossValidationBenchmark(CrossValidator<GroupedDataset<PERSON, ListDataset<FACE>, FACE>> crossValidator, GroupedDataset<PERSON, ? extends ListDataset<IMAGE>, IMAGE> dataset, FaceDetector<FACE, IMAGE> faceDetector, FaceRecogniserProvider<FACE, PERSON> engine) {
        this.dataset = dataset;
        this.crossValidator = crossValidator;
        this.faceDetector = faceDetector;
        this.engine = engine;
    }

    public void perform() {
        CMAggregator aggregator = new CMAggregator();
        GroupedDataset<PERSON, ListDataset<FACE>, FACE> faceDataset = DatasetFaceDetector.process(this.dataset, this.faceDetector);
        this.result = (AggregatedCMResult)ValidationRunner.run((ResultAggregator)aggregator, faceDataset, this.crossValidator, (ValidationOperation)new ValidationOperation<GroupedDataset<PERSON, ListDataset<FACE>, FACE>, CMResult<PERSON>>(){

            @Time(identifier="Train and Evaluate recogniser")
            public CMResult<PERSON> evaluate(GroupedDataset<PERSON, ListDataset<FACE>, FACE> training, GroupedDataset<PERSON, ListDataset<FACE>, FACE> validation) {
                FaceRecogniser rec = CrossValidationBenchmark.this.engine.create(training);
                ClassificationEvaluator eval = new ClassificationEvaluator(rec, validation, (ClassificationAnalyser)new CMAnalyser(CMAnalyser.Strategy.SINGLE));
                return (CMResult)eval.analyse(eval.evaluate());
            }
        });
    }

    public void setup() {
    }

    public void finish(ExperimentContext context) {
    }
}

