/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.feature;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.feature.FloatFV;
import org.openimaj.image.FImage;
import org.openimaj.image.feature.FImage2FloatFV;
import org.openimaj.image.processing.face.alignment.FaceAligner;
import org.openimaj.image.processing.face.alignment.ScalingAligner;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.feature.FacialFeature;
import org.openimaj.image.processing.face.feature.FacialFeatureExtractor;
import org.openimaj.io.IOUtils;

public class FaceImageFeature
implements FacialFeature,
FeatureVectorProvider<FloatFV> {
    private FloatFV feature;

    public FaceImageFeature(FloatFV feature) {
        this.feature = feature;
    }

    public void readBinary(DataInput in) throws IOException {
        this.feature = new FloatFV();
        this.feature.readBinary(in);
    }

    public byte[] binaryHeader() {
        return this.getClass().getName().getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        this.feature.writeBinary(out);
    }

    public FloatFV getFeatureVector() {
        return this.feature;
    }

    public static class Extractor<T extends DetectedFace>
    implements FacialFeatureExtractor<FaceImageFeature, T> {
        FaceAligner<T> aligner;

        public Extractor() {
            this(new ScalingAligner());
        }

        public Extractor(FaceAligner<T> aligner) {
            this.aligner = aligner;
        }

        public FaceImageFeature extractFeature(T face) {
            FImage faceImage = this.aligner.align(face);
            FloatFV feature = FImage2FloatFV.INSTANCE.extractFeature(faceImage);
            return new FaceImageFeature(feature);
        }

        public void readBinary(DataInput in) throws IOException {
            String alignerClass = in.readUTF();
            this.aligner = (FaceAligner)IOUtils.newInstance((String)alignerClass);
            this.aligner.readBinary(in);
        }

        public byte[] binaryHeader() {
            return this.getClass().getName().getBytes();
        }

        public void writeBinary(DataOutput out) throws IOException {
            out.writeUTF(this.aligner.getClass().getName());
            this.aligner.writeBinary(out);
        }
    }
}

