/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection.keypoints;

import Jama.Matrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.openimaj.io.ReadWriteableBinary;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;

public class FacialKeypoint
implements ReadWriteableBinary {
    public FacialKeypointType type;
    public Point2dImpl position;

    public FacialKeypoint() {
        this.type = FacialKeypointType.EYE_LEFT_CENTER;
        this.position = new Point2dImpl(0.0f, 0.0f);
    }

    public FacialKeypoint(FacialKeypointType type) {
        this.type = type;
        this.position = new Point2dImpl(0.0f, 0.0f);
    }

    public FacialKeypoint(FacialKeypointType type, Point2d pt) {
        this.type = type;
        this.position = new Point2dImpl(pt);
    }

    protected void updatePosition(Matrix transform) {
        this.position = this.position.transform(transform);
    }

    protected static void updateImagePosition(FacialKeypoint[] kpts, Matrix transform) {
        for (FacialKeypoint k : kpts) {
            k.updatePosition(transform);
        }
    }

    public static FacialKeypoint getKeypoint(FacialKeypoint[] pts, FacialKeypointType type) {
        for (FacialKeypoint fk : pts) {
            if (fk.type != type) continue;
            return fk;
        }
        return null;
    }

    public void readBinary(DataInput in) throws IOException {
        this.type = FacialKeypointType.valueOf(in.readUTF());
        this.position.readBinary(in);
    }

    public byte[] binaryHeader() {
        return this.getClass().getName().getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeUTF(this.type.name());
        this.position.writeBinary(out);
    }

    public static enum FacialKeypointType {
        EYE_LEFT_LEFT,
        EYE_LEFT_RIGHT,
        EYE_RIGHT_LEFT,
        EYE_RIGHT_RIGHT,
        NOSE_LEFT,
        NOSE_MIDDLE,
        NOSE_RIGHT,
        MOUTH_LEFT,
        MOUTH_RIGHT,
        EYE_LEFT_CENTER,
        EYE_RIGHT_CENTER,
        NOSE_BRIDGE,
        MOUTH_CENTER;


        public static FacialKeypointType valueOf(int ordinal) {
            return FacialKeypointType.values()[ordinal];
        }
    }
}

