/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection.benchmarking;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.detection.benchmarking.Matcher;

public class Results {
    int N;
    double scoreThreshold;
    double TPCont;
    double TPDisc;
    double FP;
    String imName;

    Results() {
    }

    Results(Results r) {
        if (r != null) {
            this.N = r.N;
            this.TPCont = r.TPCont;
            this.TPDisc = r.TPDisc;
            this.FP = r.FP;
            this.scoreThreshold = r.scoreThreshold;
        }
    }

    Results(Results r, int N2) {
        if (r != null) {
            this.imName = r.imName;
            this.N = r.N + N2;
            this.TPCont = r.TPCont;
            this.TPDisc = r.TPDisc;
            this.FP = r.FP;
            this.scoreThreshold = r.scoreThreshold;
        }
    }

    Results(Results r1, Results r2) {
        this.N = 0;
        this.TPDisc = 0.0;
        this.TPCont = 0.0;
        this.FP = 0.0;
        this.scoreThreshold = Double.MAX_VALUE;
        if (r1 != null) {
            this.imName = r1.imName;
            this.N += r1.N;
            this.TPCont += r1.TPCont;
            this.TPDisc += r1.TPDisc;
            this.FP += r1.FP;
            if (r1.scoreThreshold < this.scoreThreshold) {
                this.scoreThreshold = r1.scoreThreshold;
            }
        }
        if (r2 != null) {
            this.imName = r2.imName;
            this.N += r2.N;
            this.TPCont += r2.TPCont;
            this.TPDisc += r2.TPDisc;
            this.FP += r2.FP;
            if (r2.scoreThreshold < this.scoreThreshold) {
                this.scoreThreshold = r2.scoreThreshold;
            }
        }
    }

    Results(String s, double scoreThresh, List<Matcher.Match> mp, List<? extends DetectedFace> annot, List<? extends DetectedFace> det) {
        this.imName = s;
        this.scoreThreshold = scoreThresh;
        this.N = annot.size();
        this.FP = det.size();
        this.TPCont = 0.0;
        this.TPDisc = 0.0;
        if (mp != null) {
            for (int i = 0; i < mp.size(); ++i) {
                double score = mp.get((int)i).score;
                this.TPCont += score;
                if (!(score > 0.5)) continue;
                this.TPDisc += 1.0;
                this.FP -= 1.0;
            }
        }
    }

    static List<Results> merge(List<Results> rv1, List<Results> rv2) {
        ArrayList<Results> mergeV;
        block11: {
            int n2;
            block10: {
                Results newR;
                mergeV = new ArrayList<Results>();
                int n1 = 0;
                if (rv1 != null) {
                    n1 = rv1.size();
                }
                n2 = 0;
                if (rv2 != null) {
                    n2 = rv2.size();
                }
                int nAnnot1 = 0;
                int nAnnot2 = 0;
                if (n1 <= 0) break block10;
                nAnnot1 = rv1.get(0).getN();
                if (n2 > 0) {
                    nAnnot2 = rv2.get(0).getN();
                }
                int i1 = 0;
                int i2 = 0;
                Results r1 = null;
                Results r2 = null;
                while (i1 < n1) {
                    r1 = rv1.get(i1);
                    double score1 = rv1.get((int)i1).scoreThreshold;
                    if (i2 < n2) {
                        r2 = rv2.get(i2);
                        double score2 = rv2.get((int)i2).scoreThreshold;
                        newR = new Results(r1, r2);
                        mergeV.add(newR);
                        if (score1 < score2) {
                            ++i1;
                            continue;
                        }
                        if (score1 == score2) {
                            ++i1;
                            ++i2;
                            continue;
                        }
                        ++i2;
                        continue;
                    }
                    while (i1 < n1) {
                        r1 = rv1.get(i1);
                        newR = new Results(r1, nAnnot2);
                        mergeV.add(newR);
                        ++i1;
                    }
                }
                while (i2 < n2) {
                    r2 = rv2.get(i2);
                    newR = new Results(r2, nAnnot1);
                    mergeV.add(newR);
                    ++i2;
                }
                break block11;
            }
            if (n2 <= 0) break block11;
            for (int i = 0; i < n2; ++i) {
                mergeV.add(new Results(rv2.get(i)));
            }
        }
        return mergeV;
    }

    public String toString() {
        return this.imName + " Threshold = " + this.scoreThreshold + " N = " + this.N + " TP cont = " + this.TPCont + " TP disc = " + this.TPDisc + " FP = " + this.FP;
    }

    public static String getROCData(List<Results> rv) {
        String osc = "";
        String osd = "";
        for (int i = 0; i < rv.size(); ++i) {
            Results r = rv.get(i);
            if (r.N > 0) {
                osc = osc + r.TPCont / (double)r.N + " " + r.FP + "\n";
                osd = osd + r.TPDisc / (double)r.N + " " + r.FP + " " + r.scoreThreshold + "\n";
                continue;
            }
            osc = osc + "0 0\n";
            osd = osd + "0 0 " + r.scoreThreshold + "\n";
        }
        return "DISCRETE:\n" + osd + "\nCONTINOUS:\n" + osc;
    }

    public int getN() {
        return this.N;
    }
}

