/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.StringTokenizer;
import org.antlr.analysis.DFA;
import org.antlr.misc.Utils;
import org.antlr.runtime.misc.Stats;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Rule;

public class GrammarReport {
    public static final String Version = "4";
    public static final String GRAMMAR_STATS_FILENAME = "grammar.stats";
    public static final int NUM_GRAMMAR_STATS = 41;
    public static final String newline = System.getProperty("line.separator");
    public Grammar grammar;

    public GrammarReport(Grammar grammar) {
        this.grammar = grammar;
    }

    public String toNotifyString() {
        StringBuffer buf = new StringBuffer();
        buf.append(Version);
        buf.append('\t');
        buf.append(this.grammar.name);
        buf.append('\t');
        buf.append(this.grammar.getGrammarTypeString());
        buf.append('\t');
        buf.append(this.grammar.getOption("language"));
        int totalNonSynPredProductions = 0;
        int totalNonSynPredRules = 0;
        Collection<Rule> rules = this.grammar.getRules();
        for (Rule r : rules) {
            if (r.name.toUpperCase().startsWith("synpred".toUpperCase())) continue;
            totalNonSynPredProductions += r.numberOfAlts;
            ++totalNonSynPredRules;
        }
        buf.append('\t');
        buf.append(totalNonSynPredRules);
        buf.append('\t');
        buf.append(totalNonSynPredProductions);
        int numACyclicDecisions = this.grammar.getNumberOfDecisions() - this.grammar.getNumberOfCyclicDecisions();
        int[] depths = new int[numACyclicDecisions];
        int[] acyclicDFAStates = new int[numACyclicDecisions];
        int[] cyclicDFAStates = new int[this.grammar.getNumberOfCyclicDecisions()];
        int acyclicIndex = 0;
        int cyclicIndex = 0;
        int numLL1 = 0;
        int numDec = 0;
        for (int i = 1; i <= this.grammar.getNumberOfDecisions(); ++i) {
            Grammar.Decision d = this.grammar.getDecision(i);
            if (d.dfa == null) continue;
            ++numDec;
            if (!d.dfa.isCyclic()) {
                int maxk = d.dfa.getMaxLookaheadDepth();
                if (maxk == 1) {
                    ++numLL1;
                }
                depths[acyclicIndex] = maxk;
                acyclicDFAStates[acyclicIndex] = d.dfa.getNumberOfStates();
                ++acyclicIndex;
                continue;
            }
            cyclicDFAStates[cyclicIndex] = d.dfa.getNumberOfStates();
            ++cyclicIndex;
        }
        buf.append('\t');
        buf.append(numDec);
        buf.append('\t');
        buf.append(this.grammar.getNumberOfCyclicDecisions());
        buf.append('\t');
        buf.append(numLL1);
        buf.append('\t');
        buf.append(Stats.min((int[])depths));
        buf.append('\t');
        buf.append(Stats.max((int[])depths));
        buf.append('\t');
        buf.append(Stats.avg((int[])depths));
        buf.append('\t');
        buf.append(Stats.stddev((int[])depths));
        buf.append('\t');
        buf.append(Stats.min((int[])acyclicDFAStates));
        buf.append('\t');
        buf.append(Stats.max((int[])acyclicDFAStates));
        buf.append('\t');
        buf.append(Stats.avg((int[])acyclicDFAStates));
        buf.append('\t');
        buf.append(Stats.stddev((int[])acyclicDFAStates));
        buf.append('\t');
        buf.append(Stats.sum((int[])acyclicDFAStates));
        buf.append('\t');
        buf.append(Stats.min((int[])cyclicDFAStates));
        buf.append('\t');
        buf.append(Stats.max((int[])cyclicDFAStates));
        buf.append('\t');
        buf.append(Stats.avg((int[])cyclicDFAStates));
        buf.append('\t');
        buf.append(Stats.stddev((int[])cyclicDFAStates));
        buf.append('\t');
        buf.append(Stats.sum((int[])cyclicDFAStates));
        buf.append('\t');
        buf.append(this.grammar.getTokenTypes().size());
        buf.append('\t');
        buf.append(this.grammar.DFACreationWallClockTimeInMS);
        buf.append('\t');
        buf.append(this.grammar.numberOfSemanticPredicates);
        buf.append('\t');
        buf.append(this.grammar.numberOfManualLookaheadOptions);
        buf.append('\t');
        buf.append(this.grammar.setOfNondeterministicDecisionNumbers.size());
        buf.append('\t');
        buf.append(this.grammar.setOfNondeterministicDecisionNumbersResolvedWithPredicates.size());
        buf.append('\t');
        buf.append(this.grammar.setOfDFAWhoseAnalysisTimedOut.size());
        buf.append('\t');
        buf.append(ErrorManager.getErrorState().errors);
        buf.append('\t');
        buf.append(ErrorManager.getErrorState().warnings);
        buf.append('\t');
        buf.append(ErrorManager.getErrorState().infos);
        buf.append('\t');
        LinkedHashMap synpreds = this.grammar.getSyntacticPredicates();
        int num_synpreds = synpreds != null ? synpreds.size() : 0;
        buf.append(num_synpreds);
        buf.append('\t');
        buf.append(this.grammar.blocksWithSynPreds.size());
        buf.append('\t');
        buf.append(this.grammar.decisionsWhoseDFAsUsesSynPreds.size());
        buf.append('\t');
        buf.append(this.grammar.blocksWithSemPreds.size());
        buf.append('\t');
        buf.append(this.grammar.decisionsWhoseDFAsUsesSemPreds.size());
        buf.append('\t');
        String output = (String)this.grammar.getOption("output");
        if (output == null) {
            output = "none";
        }
        buf.append(output);
        buf.append('\t');
        Object k = this.grammar.getOption("k");
        if (k == null) {
            k = "none";
        }
        buf.append(k);
        buf.append('\t');
        String backtrack = (String)this.grammar.getOption("backtrack");
        if (backtrack == null) {
            backtrack = "false";
        }
        buf.append(backtrack);
        return buf.toString();
    }

    public String getBacktrackingReport() {
        StringBuffer buf = new StringBuffer();
        buf.append("Backtracking report:");
        buf.append(newline);
        buf.append("Number of decisions that backtrack: ");
        buf.append(this.grammar.decisionsWhoseDFAsUsesSynPreds.size());
        buf.append(newline);
        buf.append(this.getDFALocations(this.grammar.decisionsWhoseDFAsUsesSynPreds));
        return buf.toString();
    }

    public String getAnalysisTimeoutReport() {
        StringBuffer buf = new StringBuffer();
        buf.append("NFA conversion early termination report:");
        buf.append(newline);
        buf.append("Number of NFA conversions that terminated early: ");
        buf.append(this.grammar.setOfDFAWhoseAnalysisTimedOut.size());
        buf.append(newline);
        buf.append(this.getDFALocations(this.grammar.setOfDFAWhoseAnalysisTimedOut));
        return buf.toString();
    }

    protected String getDFALocations(Set dfas) {
        HashSet<Integer> decisions = new HashSet<Integer>();
        StringBuffer buf = new StringBuffer();
        for (DFA dfa : dfas) {
            if (decisions.contains(Utils.integer(dfa.decisionNumber))) continue;
            decisions.add(Utils.integer(dfa.decisionNumber));
            buf.append("Rule ");
            buf.append(dfa.decisionNFAStartState.enclosingRule.name);
            buf.append(" decision ");
            buf.append(dfa.decisionNumber);
            buf.append(" location ");
            GrammarAST decisionAST = dfa.decisionNFAStartState.associatedASTNode;
            buf.append(decisionAST.getLine());
            buf.append(":");
            buf.append(decisionAST.getColumn());
            buf.append(newline);
        }
        return buf.toString();
    }

    public String toString() {
        return GrammarReport.toString(this.toNotifyString());
    }

    protected static String[] decodeReportData(String data) {
        String[] fields = new String[41];
        StringTokenizer st = new StringTokenizer(data, "\t");
        int i = 0;
        while (st.hasMoreTokens()) {
            fields[i] = st.nextToken();
            ++i;
        }
        if (i != 41) {
            return null;
        }
        return fields;
    }

    public static String toString(String notifyDataLine) {
        String[] fields = GrammarReport.decodeReportData(notifyDataLine);
        if (fields == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("ANTLR Grammar Report; Stats Version ");
        buf.append(fields[0]);
        buf.append('\n');
        buf.append("Grammar: ");
        buf.append(fields[1]);
        buf.append('\n');
        buf.append("Type: ");
        buf.append(fields[2]);
        buf.append('\n');
        buf.append("Target language: ");
        buf.append(fields[3]);
        buf.append('\n');
        buf.append("Output: ");
        buf.append(fields[38]);
        buf.append('\n');
        buf.append("Grammar option k: ");
        buf.append(fields[39]);
        buf.append('\n');
        buf.append("Grammar option backtrack: ");
        buf.append(fields[40]);
        buf.append('\n');
        buf.append("Rules: ");
        buf.append(fields[4]);
        buf.append('\n');
        buf.append("Productions: ");
        buf.append(fields[5]);
        buf.append('\n');
        buf.append("Decisions: ");
        buf.append(fields[6]);
        buf.append('\n');
        buf.append("Cyclic DFA decisions: ");
        buf.append(fields[7]);
        buf.append('\n');
        buf.append("LL(1) decisions: ");
        buf.append(fields[8]);
        buf.append('\n');
        buf.append("Min fixed k: ");
        buf.append(fields[9]);
        buf.append('\n');
        buf.append("Max fixed k: ");
        buf.append(fields[10]);
        buf.append('\n');
        buf.append("Average fixed k: ");
        buf.append(fields[11]);
        buf.append('\n');
        buf.append("Standard deviation of fixed k: ");
        buf.append(fields[12]);
        buf.append('\n');
        buf.append("Min acyclic DFA states: ");
        buf.append(fields[13]);
        buf.append('\n');
        buf.append("Max acyclic DFA states: ");
        buf.append(fields[14]);
        buf.append('\n');
        buf.append("Average acyclic DFA states: ");
        buf.append(fields[15]);
        buf.append('\n');
        buf.append("Standard deviation of acyclic DFA states: ");
        buf.append(fields[16]);
        buf.append('\n');
        buf.append("Total acyclic DFA states: ");
        buf.append(fields[17]);
        buf.append('\n');
        buf.append("Min cyclic DFA states: ");
        buf.append(fields[18]);
        buf.append('\n');
        buf.append("Max cyclic DFA states: ");
        buf.append(fields[19]);
        buf.append('\n');
        buf.append("Average cyclic DFA states: ");
        buf.append(fields[20]);
        buf.append('\n');
        buf.append("Standard deviation of cyclic DFA states: ");
        buf.append(fields[21]);
        buf.append('\n');
        buf.append("Total cyclic DFA states: ");
        buf.append(fields[22]);
        buf.append('\n');
        buf.append("Vocabulary size: ");
        buf.append(fields[23]);
        buf.append('\n');
        buf.append("DFA creation time in ms: ");
        buf.append(fields[24]);
        buf.append('\n');
        buf.append("Number of semantic predicates found: ");
        buf.append(fields[25]);
        buf.append('\n');
        buf.append("Number of manual fixed lookahead k=value options: ");
        buf.append(fields[26]);
        buf.append('\n');
        buf.append("Number of nondeterministic decisions: ");
        buf.append(fields[27]);
        buf.append('\n');
        buf.append("Number of nondeterministic decisions resolved with predicates: ");
        buf.append(fields[28]);
        buf.append('\n');
        buf.append("Number of DFA conversions terminated early: ");
        buf.append(fields[29]);
        buf.append('\n');
        buf.append("Number of errors: ");
        buf.append(fields[30]);
        buf.append('\n');
        buf.append("Number of warnings: ");
        buf.append(fields[31]);
        buf.append('\n');
        buf.append("Number of infos: ");
        buf.append(fields[32]);
        buf.append('\n');
        buf.append("Number of syntactic predicates found: ");
        buf.append(fields[33]);
        buf.append('\n');
        buf.append("Decisions with syntactic predicates: ");
        buf.append(fields[34]);
        buf.append('\n');
        buf.append("Decision DFAs using syntactic predicates: ");
        buf.append(fields[35]);
        buf.append('\n');
        buf.append("Decisions with semantic predicates: ");
        buf.append(fields[36]);
        buf.append('\n');
        buf.append("Decision DFAs using semantic predicates: ");
        buf.append(fields[37]);
        buf.append('\n');
        return buf.toString();
    }
}

