/*
 * Decompiled with CFR 0.152.
 */
package opennlp.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import opennlp.model.ComparableEvent;
import opennlp.model.Event;
import opennlp.model.EventStream;
import opennlp.model.OnePassDataIndexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnePassRealValueDataIndexer
extends OnePassDataIndexer {
    float[][] values;

    public OnePassRealValueDataIndexer(EventStream eventStream, int cutoff, boolean sort) throws IOException {
        super(eventStream, cutoff, sort);
    }

    public OnePassRealValueDataIndexer(EventStream eventStream, int cutoff) throws IOException {
        super(eventStream, cutoff);
    }

    @Override
    public float[][] getValues() {
        return this.values;
    }

    @Override
    protected int sortAndMerge(List eventsToCompare, boolean sort) {
        int numUniqueEvents = super.sortAndMerge(eventsToCompare, sort);
        this.values = new float[numUniqueEvents][];
        int numEvents = eventsToCompare.size();
        int j = 0;
        for (int i = 0; i < numEvents; ++i) {
            ComparableEvent evt = (ComparableEvent)eventsToCompare.get(i);
            if (null == evt) continue;
            this.values[j++] = evt.values;
        }
        return numUniqueEvents;
    }

    @Override
    protected List index(LinkedList<Event> events, Map<String, Integer> predicateIndex) {
        HashMap<String, Integer> omap = new HashMap<String, Integer>();
        int numEvents = events.size();
        int outcomeCount = 0;
        ArrayList<ComparableEvent> eventsToCompare = new ArrayList<ComparableEvent>(numEvents);
        ArrayList<Integer> indexedContext = new ArrayList<Integer>();
        for (int eventIndex = 0; eventIndex < numEvents; ++eventIndex) {
            int ocID;
            Event ev = events.removeFirst();
            String[] econtext = ev.getContext();
            String oc = ev.getOutcome();
            if (omap.containsKey(oc)) {
                ocID = (Integer)omap.get(oc);
            } else {
                ocID = outcomeCount++;
                omap.put(oc, ocID);
            }
            for (int i = 0; i < econtext.length; ++i) {
                String pred = econtext[i];
                if (!predicateIndex.containsKey(pred)) continue;
                indexedContext.add(predicateIndex.get(pred));
            }
            if (indexedContext.size() > 0) {
                int[] cons = new int[indexedContext.size()];
                for (int ci = 0; ci < cons.length; ++ci) {
                    cons[ci] = (Integer)indexedContext.get(ci);
                }
                ComparableEvent ce = new ComparableEvent(ocID, cons, ev.getValues());
                eventsToCompare.add(ce);
            } else {
                System.err.println("Dropped event " + ev.getOutcome() + ":" + Arrays.asList(ev.getContext()));
            }
            indexedContext.clear();
        }
        this.outcomeLabels = OnePassRealValueDataIndexer.toIndexedStringArray(omap);
        this.predLabels = OnePassRealValueDataIndexer.toIndexedStringArray(predicateIndex);
        return eventsToCompare;
    }
}

