/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.ModelSet;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.node.BlankNode;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtils {
    public static int size(Iterable<?> it) {
        int count = 0;
        Iterator<?> i = it.iterator();
        while (i.hasNext()) {
            i.next();
            ++count;
        }
        return count;
    }

    public static int size(Iterator<?> i) {
        int count = 0;
        while (i.hasNext()) {
            i.next();
            ++count;
        }
        return count;
    }

    public static void copy(ModelSet source, ModelSet target) throws ModelRuntimeException {
        ClosableIterator<Model> i = source.getModels();
        while (i.hasNext()) {
            Model m = (Model)i.next();
            m.open();
            Model tm = target.getModel(m.getContextURI());
            tm.open();
            ModelUtils.copy(m, tm);
        }
        Model m = source.getDefaultModel();
        m.open();
        Model tm = target.getDefaultModel();
        tm.open();
        ModelUtils.copy(m, tm);
    }

    public static void copy(Model source, Model target) {
        if (source.getUnderlyingModelImplementation().equals(target.getUnderlyingModelImplementation().getClass())) {
            ClosableIterator it = source.iterator();
            target.addAll(it);
            it.close();
        } else {
            HashMap<String, BlankNode> bnodeSourceId2bnodeTarget = new HashMap<String, BlankNode>();
            ClosableIterator it = source.iterator();
            while (it.hasNext()) {
                Statement stmt = (Statement)it.next();
                boolean blankSubject = stmt.getSubject() instanceof BlankNode;
                boolean blankObject = stmt.getObject() instanceof BlankNode;
                if (blankSubject || blankObject) {
                    Resource s = blankSubject ? ModelUtils.transform(stmt.getSubject().asBlankNode(), bnodeSourceId2bnodeTarget, target) : stmt.getSubject();
                    Node o = blankObject ? ModelUtils.transform(stmt.getObject().asBlankNode(), bnodeSourceId2bnodeTarget, target) : stmt.getObject();
                    target.addStatement(s, stmt.getPredicate(), o);
                    continue;
                }
                target.addStatement(stmt);
            }
            it.close();
        }
    }

    private static BlankNode transform(BlankNode source, Map<String, BlankNode> map, Model target) {
        String bnodeSourceId = source.getInternalID();
        BlankNode bnodeTarget = map.get(bnodeSourceId);
        if (bnodeTarget == null) {
            bnodeTarget = target.createBlankNode();
            map.put(bnodeSourceId, bnodeTarget);
        }
        return bnodeTarget;
    }

    public static void removeFrom(ModelSet source, ModelSet target) throws ModelRuntimeException {
        ClosableIterator<Model> it = source.getModels();
        while (it.hasNext()) {
            Model m = it.next();
            ClosableIterator modelIt = m.iterator();
            target.getModel(m.getContextURI()).removeAll(modelIt);
            modelIt.close();
        }
        it.close();
        ClosableIterator modelIt = source.getDefaultModel().iterator();
        target.getDefaultModel().removeAll(modelIt);
        modelIt.close();
    }

    public static Model intersection(Model a, Model b, Model result) throws ModelRuntimeException {
        for (Statement s : a) {
            if (!b.contains(s)) continue;
            result.addStatement(s);
        }
        return result;
    }

    public static Model union(Model a, Model b, Model result) throws ModelRuntimeException {
        ClosableIterator it = a.iterator();
        result.addAll(it);
        it.close();
        it = b.iterator();
        result.addAll(it);
        it.close();
        return result;
    }

    public static Model complement(Model a, Model b, Model result) throws ModelRuntimeException {
        ClosableIterator it = a.iterator();
        result.addAll(it);
        it.close();
        it = b.iterator();
        result.removeAll(it);
        it.close();
        return result;
    }

    public static void convert(File in, Syntax inSyntax, File out, Syntax outSyntax) throws FileNotFoundException {
        if (!in.exists()) {
            throw new FileNotFoundException("Input file " + in.getAbsolutePath() + " not found");
        }
        if (!out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
        }
        Model m = RDF2Go.getModelFactory().createModel();
        m.open();
        FileReader fr = null;
        OutputStreamWriter fw = null;
        try {
            fr = new FileReader(in);
            m.readFrom(fr, inSyntax);
            fw = new FileWriter(out);
            m.writeTo(fw, outSyntax);
        }
        catch (ModelRuntimeException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        m.close();
    }

    @Deprecated
    public static Model loadFromFile(File in, Syntax inSyntax) throws ModelRuntimeException, IOException {
        Model model = RDF2Go.getModelFactory().createModel();
        model.open();
        FileInputStream fin = new FileInputStream(in);
        model.readFrom(fin, inSyntax);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFromFile(File in, Syntax inSyntax, Model sinkModel) throws ModelRuntimeException, IOException {
        if (!sinkModel.isOpen()) {
            throw new IllegalArgumentException("SinkModel must be open");
        }
        FileInputStream fin = new FileInputStream(in);
        try {
            sinkModel.readFrom(fin, inSyntax);
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(Model model, File outFile, Syntax outSyntax) throws ModelRuntimeException, IOException {
        FileOutputStream fout = new FileOutputStream(outFile);
        try {
            model.writeTo(fout, outSyntax);
        }
        finally {
            fout.close();
        }
    }

    public static void convert(File[] inFiles, Syntax[] inSyntax, File out, Syntax outSyntax) throws ModelRuntimeException, IOException {
        Model merged = RDF2Go.getModelFactory().createModel();
        for (int i = 0; i < inFiles.length; ++i) {
            Model inModel = ModelUtils.loadFromFile(inFiles[i], inSyntax[i]);
            ClosableIterator it = inModel.iterator();
            merged.addAll(it);
            it.close();
        }
        ModelUtils.writeToFile(merged, out, outSyntax);
    }
}

