/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.model.node.impl;

import org.ontoware.rdf2go.model.node.DatatypeLiteral;
import org.ontoware.rdf2go.model.node.LanguageTagLiteral;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.impl.LiteralImpl;
import org.ontoware.rdf2go.model.node.impl.NodeUtils;

public class LanguageTagLiteralImpl
extends LiteralImpl
implements LanguageTagLiteral {
    private String languageTag;
    private String literalValue;

    public LanguageTagLiteralImpl(String string, String languageTag) {
        assert (languageTag != null);
        assert (string != null);
        this.languageTag = languageTag.toLowerCase();
        this.literalValue = string;
    }

    public LanguageTagLiteralImpl(String turtleEncoded) {
        assert (turtleEncoded.contains("@"));
        int i = turtleEncoded.lastIndexOf(64);
        this.literalValue = turtleEncoded.substring(0, i).toLowerCase();
        this.languageTag = turtleEncoded.substring(i + 1);
    }

    public String getValue() {
        return this.literalValue;
    }

    public String getLanguageTag() {
        return this.languageTag;
    }

    public boolean equals(Object o) {
        return o instanceof LanguageTagLiteralImpl && this.getValue().equals(((LanguageTagLiteralImpl)o).getValue()) && this.getLanguageTag().equals(((LanguageTagLiteralImpl)o).getLanguageTag());
    }

    public String toString() {
        return this.getValue() + "@" + this.getLanguageTag();
    }

    public DatatypeLiteral asDatatypeLiteral() throws ClassCastException {
        throw new ClassCastException("Cannot call this on a language tagged literal");
    }

    public LanguageTagLiteral asLanguageTagLiteral() throws ClassCastException {
        return this;
    }

    public int hashCode() {
        return this.languageTag.hashCode() + this.literalValue.hashCode();
    }

    public int compareTo(Node other) {
        if (other instanceof LanguageTagLiteral) {
            LanguageTagLiteral oLit = (LanguageTagLiteral)other;
            int diff = this.getValue().compareTo(oLit.getValue());
            if (diff != 0) {
                return diff;
            }
            return this.getLanguageTag().compareTo(oLit.getLanguageTag());
        }
        return NodeUtils.compareByType(this, other);
    }

    public String toSPARQL() {
        return "'''" + LanguageTagLiteralImpl.sparqlEncode(this.literalValue) + "'''@" + this.languageTag;
    }
}

