/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.DiffReader;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.ModelChangedListener;
import org.ontoware.rdf2go.model.ModelSet;
import org.ontoware.rdf2go.model.NotifyingModelSet;
import org.ontoware.rdf2go.model.QuadPattern;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.impl.DelegatingModelSet;
import org.ontoware.rdf2go.model.impl.NotifyingModelLayer;
import org.ontoware.rdf2go.model.impl.PseudoClosableIterator;
import org.ontoware.rdf2go.model.impl.QuadPatternImpl;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifyingModelSetLayer
extends DelegatingModelSet
implements NotifyingModelSet {
    private Map<ModelChangedListener, QuadPattern> modelsetChangeListener = new HashMap<ModelChangedListener, QuadPattern>();

    public NotifyingModelSetLayer(ModelSet modelset) {
        super(modelset);
    }

    @Override
    public void addModelSetChangedListener(ModelChangedListener listener) {
        this.modelsetChangeListener.put(listener, new QuadPatternImpl(Variable.ANY, (ResourceOrVariable)Variable.ANY, Variable.ANY, Variable.ANY));
    }

    @Override
    public void addModelSetChangedListener(ModelChangedListener listener, QuadPattern pattern) {
        this.modelsetChangeListener.put(listener, pattern);
    }

    @Override
    public void removeModelSetChangedListener(ModelChangedListener listener) {
        this.modelsetChangeListener.remove(listener);
    }

    @Override
    public boolean addModel(Model model) {
        for (Map.Entry<ModelChangedListener, QuadPattern> entry : this.modelsetChangeListener.entrySet()) {
            if (entry.getValue().getContext() != Variable.ANY && !entry.getValue().getContext().equals(model.getContextURI())) continue;
            for (Statement stmt : model) {
                if (!entry.getValue().matches(stmt)) continue;
                entry.getKey().addedStatement(stmt);
            }
        }
        return super.addModel(model);
    }

    @Override
    public void addStatement(Statement statement) throws ModelRuntimeException {
        for (Map.Entry<ModelChangedListener, QuadPattern> entry : this.modelsetChangeListener.entrySet()) {
            if (!entry.getValue().matches(statement)) continue;
            entry.getKey().addedStatement(statement);
        }
        super.addStatement(statement);
    }

    @Override
    public Model getDefaultModel() {
        Model model = super.getDefaultModel();
        NotifyingModelLayer notifyingModel = new NotifyingModelLayer(model);
        for (Map.Entry<ModelChangedListener, QuadPattern> entry : this.modelsetChangeListener.entrySet()) {
            if (entry.getValue().getContext() != Variable.ANY) continue;
            notifyingModel.addModelChangedListener(entry.getKey(), entry.getValue());
        }
        return notifyingModel;
    }

    @Override
    public Model getModel(URI contextURI) {
        Model model = super.getModel(contextURI);
        NotifyingModelLayer notifyingModel = new NotifyingModelLayer(model);
        for (Map.Entry<ModelChangedListener, QuadPattern> entry : this.modelsetChangeListener.entrySet()) {
            if (entry.getValue().getContext() != Variable.ANY && !entry.getValue().getContext().equals(contextURI)) continue;
            notifyingModel.addModelChangedListener(entry.getKey(), entry.getValue());
        }
        return notifyingModel;
    }

    @Override
    public ClosableIterator<Model> getModels() {
        ArrayList<NotifyingModelLayer> models = new ArrayList<NotifyingModelLayer>();
        ClosableIterator<Model> it = super.getModels();
        while (it.hasNext()) {
            Model model = it.next();
            NotifyingModelLayer notifyingModel = new NotifyingModelLayer(model);
            for (Map.Entry<ModelChangedListener, QuadPattern> entry : this.modelsetChangeListener.entrySet()) {
                notifyingModel.addModelChangedListener(entry.getKey(), entry.getValue());
            }
            models.add(notifyingModel);
        }
        it.close();
        return new PseudoClosableIterator<Model>(models.iterator());
    }

    @Override
    public void removeStatement(Statement statement) throws ModelRuntimeException {
        for (Map.Entry<ModelChangedListener, QuadPattern> entry : this.modelsetChangeListener.entrySet()) {
            if (!entry.getValue().matches(statement)) continue;
            entry.getKey().removedStatement(statement);
        }
        super.removeStatement(statement);
    }

    @Override
    public void update(DiffReader diff) throws ModelRuntimeException {
        for (Map.Entry<ModelChangedListener, QuadPattern> entry : this.modelsetChangeListener.entrySet()) {
            entry.getKey().performedUpdate(diff);
        }
        super.update(diff);
    }
}

