/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.model.impl;

import java.util.Iterator;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.TriplePattern;
import org.ontoware.rdf2go.model.impl.AbstractModelSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyUnionModelIterator
implements ClosableIterator<Statement> {
    private TriplePattern pattern;
    private Iterator<? extends Model> modelit;
    private ClosableIterator<? extends Statement> stmtit;

    public LazyUnionModelIterator(AbstractModelSetImpl impl, TriplePattern pattern) {
        this.pattern = pattern;
        this.modelit = impl.getModels();
    }

    @Override
    public void close() {
        this.stmtit.close();
    }

    @Override
    public boolean hasNext() {
        this.getNonEmptyStmtIterator();
        return this.stmtit.hasNext();
    }

    @Override
    public Statement next() {
        this.getNonEmptyStmtIterator();
        return this.stmtit.next();
    }

    private void getNonEmptyStmtIterator() {
        Model m;
        if (this.stmtit == null) {
            m = this.modelit.next();
            m.open();
            this.stmtit = m.findStatements(this.pattern);
        }
        while (this.modelit.hasNext() && !this.stmtit.hasNext()) {
            this.stmtit.close();
            m = this.modelit.next();
            m.open();
            this.stmtit = m.findStatements(this.pattern);
        }
    }

    @Override
    public void remove() {
        this.getNonEmptyStmtIterator();
        this.stmtit.remove();
    }
}

