/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.impl;

import java.util.Properties;
import org.ontoware.rdf2go.ModelFactory;
import org.ontoware.rdf2go.Reasoning;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.exception.ReasoningNotSupportedException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.ModelSet;

public abstract class AbstractModelFactory
implements ModelFactory {
    public Model createModel() throws ModelRuntimeException {
        Properties properties = new Properties();
        properties.put("Reasoning", Reasoning.none.toString());
        properties.put("Storage", "MEMORY");
        return this.createModel(properties);
    }

    public Model createModel(Reasoning reasoning) throws ModelRuntimeException, ReasoningNotSupportedException {
        Properties properties = new Properties();
        properties.put("Reasoning", reasoning.toString());
        properties.put("Storage", "MEMORY");
        return this.createModel(properties);
    }

    public ModelSet createModelSet() throws ModelRuntimeException {
        Properties properties = new Properties();
        properties.put("Reasoning", Reasoning.none.toString());
        properties.put("Storage", "MEMORY");
        return this.createModelSet(properties);
    }

    public ModelSet createModelSet(Reasoning reasoning) throws ModelRuntimeException, ReasoningNotSupportedException {
        Properties properties = new Properties();
        properties.put("Reasoning", reasoning.toString());
        properties.put("Storage", "MEMORY");
        return this.createModelSet(properties);
    }

    public static Reasoning getReasoning(Properties p) throws ModelRuntimeException {
        String reasoningString = (String)p.get("Reasoning");
        if (reasoningString == null) {
            return Reasoning.none;
        }
        Reasoning reasoning = Reasoning.valueOf(reasoningString);
        if (reasoning == null) {
            throw new IllegalArgumentException("Illegal inferencing type: " + reasoningString);
        }
        return reasoning;
    }
}

