/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hardware.kinect;

import java.nio.ByteBuffer;
import org.bridj.Pointer;
import org.openimaj.hardware.kinect.KinectStream;
import org.openimaj.hardware.kinect.KinectStreamCallback;
import org.openimaj.hardware.kinect.freenect.libfreenectLibrary;
import org.openimaj.image.Image;

public abstract class KinectVideoStreamCallback<T extends Image<?, T>>
extends libfreenectLibrary.freenect_video_cb
implements KinectStreamCallback {
    KinectStream<T> stream;
    ByteBuffer buffer;
    int nextTimeStamp;
    T nextFrame;
    boolean updated = false;

    public KinectVideoStreamCallback(KinectStream<T> stream) {
        this.stream = stream;
    }

    @Override
    public synchronized void apply(Pointer<libfreenectLibrary.freenect_device> dev, Pointer<?> video, int timestamp) {
        this.updated = true;
        this.nextTimeStamp = timestamp;
        this.setImage();
    }

    public abstract void setImage();

    @Override
    public synchronized void swapFrames() {
        if (!this.updated) {
            return;
        }
        Object tmp = this.stream.frame;
        this.stream.frame = this.nextFrame;
        this.nextFrame = tmp;
        this.stream.timeStamp = this.nextTimeStamp;
        this.updated = false;
    }

    @Override
    public abstract void stop();
}

