/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hardware.kinect;

import org.openimaj.hardware.kinect.KinectController;
import org.openimaj.hardware.kinect.KinectStreamCallback;
import org.openimaj.image.Image;
import org.openimaj.video.Video;

public abstract class KinectStream<T extends Image<?, T>>
extends Video<T> {
    KinectController controller;
    KinectStreamCallback callback;
    T frame;
    long timeStamp;
    int width;
    int height;
    double fps;

    public KinectStream(KinectController controller) {
        this.controller = controller;
    }

    public T getNextFrame() {
        ++this.currentFrame;
        this.callback.swapFrames();
        return this.frame;
    }

    public T getCurrentFrame() {
        return this.frame;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean hasNextFrame() {
        return true;
    }

    public long countFrames() {
        return this.currentFrame;
    }

    public void reset() {
    }

    public void stop() {
        this.callback.stop();
    }

    public long getTimeStamp() {
        return (long)((double)(1000 * this.currentFrame) / this.fps);
    }

    public double getFPS() {
        return this.fps;
    }
}

