/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hardware.kinect;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.bridj.Pointer;
import org.openimaj.hardware.kinect.KinectStream;
import org.openimaj.hardware.kinect.KinectVideoStreamCallback;
import org.openimaj.hardware.kinect.freenect.libfreenectLibrary;
import org.openimaj.image.FImage;

class IRVideoCallback
extends KinectVideoStreamCallback<FImage> {
    private static final float[] LUT = new float[1024];

    public IRVideoCallback(KinectStream<FImage> stream) {
        super(stream);
        Pointer<libfreenectLibrary.freenect_device> device = stream.controller.device;
        libfreenectLibrary.freenect_set_video_mode_proxy(device, libfreenectLibrary.freenect_resolution.FREENECT_RESOLUTION_MEDIUM, libfreenectLibrary.freenect_video_format.FREENECT_VIDEO_IR_10BIT);
        this.buffer = ByteBuffer.allocateDirect(libfreenectLibrary.freenect_get_video_buffer_size(device));
        libfreenectLibrary.freenect_set_video_buffer(device, Pointer.pointerToBuffer((Buffer)this.buffer));
        this.nextFrame = new FImage(stream.width, stream.height);
        libfreenectLibrary.freenect_set_video_callback(device, (Pointer<libfreenectLibrary.freenect_video_cb>)this.toPointer());
        libfreenectLibrary.freenect_start_video(device);
    }

    @Override
    public void setImage() {
        ByteBuffer buf = this.buffer.duplicate();
        int width = this.stream.width;
        int height = this.stream.height;
        float[][] pix = ((FImage)this.nextFrame).pixels;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int first = buf.get() & 0xFF;
                int second = buf.get() & 0xFF;
                pix[y][x] = LUT[first + second * 256];
            }
        }
    }

    @Override
    public void stop() {
        libfreenectLibrary.freenect_stop_video(this.stream.controller.device);
    }

    static {
        for (int i = 0; i < LUT.length; ++i) {
            IRVideoCallback.LUT[i] = (float)i / ((float)LUT.length - 1.0f);
        }
    }
}

