/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hardware.kinect;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.bridj.Pointer;
import org.openimaj.hardware.kinect.KinectDepthStream;
import org.openimaj.hardware.kinect.KinectStreamCallback;
import org.openimaj.hardware.kinect.freenect.libfreenectLibrary;
import org.openimaj.image.FImage;

class DepthCallback
extends libfreenectLibrary.freenect_depth_cb
implements KinectStreamCallback {
    private static final float[] LUT = new float[2048];
    KinectDepthStream stream;
    ByteBuffer buffer;
    int nextTimeStamp;
    FImage nextFrame;
    boolean updated = false;

    public DepthCallback(KinectDepthStream stream, boolean registeredDepthMode) {
        this.stream = stream;
        Pointer<libfreenectLibrary.freenect_device> device = stream.controller.device;
        if (registeredDepthMode) {
            libfreenectLibrary.freenect_set_depth_mode_proxy(device, libfreenectLibrary.freenect_resolution.FREENECT_RESOLUTION_MEDIUM, libfreenectLibrary.freenect_depth_format.FREENECT_DEPTH_REGISTERED);
        } else {
            libfreenectLibrary.freenect_set_depth_mode_proxy(device, libfreenectLibrary.freenect_resolution.FREENECT_RESOLUTION_MEDIUM, libfreenectLibrary.freenect_depth_format.FREENECT_DEPTH_11BIT);
        }
        this.buffer = ByteBuffer.allocateDirect(libfreenectLibrary.freenect_get_video_buffer_size(device));
        libfreenectLibrary.freenect_set_depth_buffer(device, Pointer.pointerToBuffer((Buffer)this.buffer));
        this.nextFrame = new FImage(stream.width, stream.height);
        libfreenectLibrary.freenect_set_depth_callback(device, (Pointer<libfreenectLibrary.freenect_depth_cb>)this.toPointer());
        libfreenectLibrary.freenect_start_depth(device);
    }

    @Override
    public synchronized void apply(Pointer<libfreenectLibrary.freenect_device> dev, Pointer<?> depth, int timestamp) {
        this.updated = true;
        this.nextTimeStamp = timestamp;
        this.setImage();
    }

    @Override
    public synchronized void swapFrames() {
        if (!this.updated) {
            return;
        }
        FImage tmp = (FImage)this.stream.frame;
        this.stream.frame = this.nextFrame;
        this.nextFrame = tmp;
        this.stream.timeStamp = this.nextTimeStamp;
        this.updated = false;
    }

    public void setImage() {
        ByteBuffer buf = this.buffer.duplicate();
        int width = this.stream.width;
        int height = this.stream.height;
        float[][] pix = this.nextFrame.pixels;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int first = buf.get() & 0xFF;
                int second = buf.get() & 0xFF;
                pix[y][x] = first + (second << 8);
            }
        }
    }

    @Override
    public void stop() {
        libfreenectLibrary.freenect_stop_depth(this.stream.controller.device);
    }

    static {
        for (int i = 0; i < LUT.length; ++i) {
            DepthCallback.LUT[i] = (float)i / ((float)LUT.length - 1.0f);
        }
    }
}

