/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.filter.eval;

public class ExpressionEvaluator {
    public static <T> boolean eval(T actual, String comparator, String expected) {
        if (actual instanceof Long) {
            Long a = (Long)actual;
            Long e = Long.parseLong(expected.trim());
            if ("==".equals(comparator)) {
                return a.longValue() == e.longValue();
            }
            if ("!=".equals(comparator) || "<>".equals(comparator)) {
                return a.longValue() != e.longValue();
            }
            if (">".equals(comparator)) {
                return a > e;
            }
            if (">=".equals(comparator)) {
                return a >= e;
            }
            if ("<".equals(comparator)) {
                return a < e;
            }
            if ("<=".equals(comparator)) {
                return a <= e;
            }
        } else if (actual instanceof Integer) {
            Integer a = (Integer)actual;
            Integer e = Integer.parseInt(expected.trim());
            if ("==".equals(comparator)) {
                return a.intValue() == e.intValue();
            }
            if ("!=".equals(comparator) || "<>".equals(comparator)) {
                return a.intValue() != e.intValue();
            }
            if (">".equals(comparator)) {
                return a > e;
            }
            if (">=".equals(comparator)) {
                return a >= e;
            }
            if ("<".equals(comparator)) {
                return a < e;
            }
            if ("<=".equals(comparator)) {
                return a <= e;
            }
        } else if (actual instanceof Double) {
            Double a = (Double)actual;
            Double e = Double.parseDouble(expected.trim());
            if ("==".equals(comparator)) {
                return a.doubleValue() == e.doubleValue();
            }
            if ("!=".equals(comparator) || "<>".equals(comparator)) {
                return a.doubleValue() != e.doubleValue();
            }
            if (">".equals(comparator)) {
                return a > e;
            }
            if (">=".equals(comparator)) {
                return a >= e;
            }
            if ("<".equals(comparator)) {
                return a < e;
            }
            if ("<=".equals(comparator)) {
                return a <= e;
            }
        } else if (actual instanceof String) {
            String a = (String)actual;
            if ((expected = expected.trim()).startsWith("'")) {
                expected = expected.substring(1);
            }
            if (expected.endsWith("'")) {
                expected = expected.substring(0, expected.length() - 1);
            }
            if ("==".equals(comparator)) {
                return a.equals(expected);
            }
            if ("!=".equals(comparator) || "<>".equals(comparator)) {
                return !a.equals(expected);
            }
        }
        return false;
    }
}

