/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.ClassUtil;
import org.apache.hadoop.util.ThreadUtil;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class VersionInfo {
    private static final Log LOG = LogFactory.getLog(VersionInfo.class);
    private Properties info = new Properties();
    private static VersionInfo COMMON_VERSION_INFO = new VersionInfo("common");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VersionInfo(String component) {
        String versionInfoFile = component + "-version-info.properties";
        InputStream is = null;
        try {
            is = ThreadUtil.getResourceAsStream(versionInfoFile);
            this.info.load(is);
        }
        catch (IOException ex) {
            LogFactory.getLog(this.getClass()).warn((Object)("Could not read '" + versionInfoFile + "', " + ex.toString()), (Throwable)ex);
        }
        finally {
            IOUtils.closeStream(is);
        }
    }

    protected String _getVersion() {
        return this.info.getProperty("version", "Unknown");
    }

    protected String _getRevision() {
        return this.info.getProperty("revision", "Unknown");
    }

    protected String _getBranch() {
        return this.info.getProperty("branch", "Unknown");
    }

    protected String _getDate() {
        return this.info.getProperty("date", "Unknown");
    }

    protected String _getUser() {
        return this.info.getProperty("user", "Unknown");
    }

    protected String _getUrl() {
        return this.info.getProperty("url", "Unknown");
    }

    protected String _getSrcChecksum() {
        return this.info.getProperty("srcChecksum", "Unknown");
    }

    protected String _getBuildVersion() {
        return VersionInfo.getVersion() + " from " + this._getRevision() + " by " + this._getUser() + " source checksum " + this._getSrcChecksum();
    }

    protected String _getProtocVersion() {
        return this.info.getProperty("protocVersion", "Unknown");
    }

    public static String getVersion() {
        return COMMON_VERSION_INFO._getVersion();
    }

    public static String getRevision() {
        return COMMON_VERSION_INFO._getRevision();
    }

    public static String getBranch() {
        return COMMON_VERSION_INFO._getBranch();
    }

    public static String getDate() {
        return COMMON_VERSION_INFO._getDate();
    }

    public static String getUser() {
        return COMMON_VERSION_INFO._getUser();
    }

    public static String getUrl() {
        return COMMON_VERSION_INFO._getUrl();
    }

    public static String getSrcChecksum() {
        return COMMON_VERSION_INFO._getSrcChecksum();
    }

    public static String getBuildVersion() {
        return COMMON_VERSION_INFO._getBuildVersion();
    }

    public static String getProtocVersion() {
        return COMMON_VERSION_INFO._getProtocVersion();
    }

    public static void main(String[] args) {
        LOG.debug((Object)("version: " + VersionInfo.getVersion()));
        System.out.println("Hadoop " + VersionInfo.getVersion());
        System.out.println("Subversion " + VersionInfo.getUrl() + " -r " + VersionInfo.getRevision());
        System.out.println("Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate());
        System.out.println("Compiled with protoc " + VersionInfo.getProtocVersion());
        System.out.println("From source with checksum " + VersionInfo.getSrcChecksum());
        System.out.println("This command was run using " + ClassUtil.findContainingJar(VersionInfo.class));
    }
}

