/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.data.convert.vector;

import gov.sandia.cognition.data.convert.vector.AbstractToVectorEncoder;
import gov.sandia.cognition.data.convert.vector.DataToVectorEncoder;
import gov.sandia.cognition.math.matrix.Vector;
import java.util.List;

public class UniqueBooleanVectorEncoder<InputType>
extends AbstractToVectorEncoder<InputType> {
    protected List<InputType> values;
    protected DataToVectorEncoder<Boolean> booleanConverter;

    public UniqueBooleanVectorEncoder(List<InputType> values, DataToVectorEncoder<Boolean> booleanConverter) {
        this.setValues(values);
        this.setBooleanConverter(booleanConverter);
    }

    @Override
    public void encode(InputType object, Vector vector, int startIndex) {
        boolean isNull = object == null;
        int index = startIndex;
        for (InputType value : this.values) {
            Boolean b = isNull ? null : Boolean.valueOf(value.equals(object));
            this.booleanConverter.encode(b, vector, index);
            index += this.booleanConverter.getOutputDimensionality();
        }
    }

    @Override
    public int getOutputDimensionality() {
        return this.values.size() * this.booleanConverter.getOutputDimensionality();
    }

    public List<InputType> getValues() {
        return this.values;
    }

    protected void setValues(List<InputType> values) {
        this.values = values;
    }

    public DataToVectorEncoder<Boolean> getBooleanConverter() {
        return this.booleanConverter;
    }

    protected void setBooleanConverter(DataToVectorEncoder<Boolean> booleanConverter) {
        this.booleanConverter = booleanConverter;
    }
}

