/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.internal;

import com.trolltech.qt.QFlags;
import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.QtBlockedEnum;
import com.trolltech.qt.QtBlockedSlot;
import com.trolltech.qt.QtEnumerator;
import com.trolltech.qt.QtPropertyDesignable;
import com.trolltech.qt.QtPropertyReader;
import com.trolltech.qt.QtPropertyResetter;
import com.trolltech.qt.QtPropertyUser;
import com.trolltech.qt.QtPropertyWriter;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.internal.QSignalEmitterInternal;
import com.trolltech.qt.internal.QtJambiInternal;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaObjectTools {
    private static final int MethodAccessPrivate = 0;
    private static final int MethodAccessProtected = 1;
    private static final int MethodAccessPublic = 2;
    private static final int MethodSignal = 4;
    private static final int MethodSlot = 8;
    private static final int PropertyReadable = 1;
    private static final int PropertyWritable = 2;
    private static final int PropertyResettable = 4;
    private static final int PropertyEnumOrFlag = 8;
    private static final int PropertyDesignable = 4096;
    private static final int PropertyResolveDesignable = 8192;
    private static final int PropertyStored = 65536;
    private static final int PropertyUser = 0x100000;

    private static Method notBogus(Method method, String propertyName, Class<?> paramType) {
        if (method == null) {
            return null;
        }
        Container reader = Container.readerAnnotation(method);
        if (!(reader == null || reader.name().equals(propertyName) && reader.enabled() && method.getReturnType().isAssignableFrom(paramType))) {
            return null;
        }
        return method;
    }

    private static int queryEnums(Class<?> clazz, Hashtable<String, Class<?>> enums) {
        Class<?>[] declaredClasses;
        int enumConstantCount = 0;
        for (Class<?> declaredClass : declaredClasses = clazz.getDeclaredClasses()) {
            enumConstantCount += MetaObjectTools.putEnumTypeInHash(declaredClass, enums);
        }
        return enumConstantCount;
    }

    private static Class<?> getEnumForQFlags(Class<?> flagsType) {
        Type t = flagsType.getGenericSuperclass();
        if (t instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)t).getActualTypeArguments();
            return (Class)typeArguments[0];
        }
        return null;
    }

    private static int putEnumTypeInHash(Class<?> type, Hashtable<String, Class<?>> enums) {
        Class<?> enumType;
        Class<?> flagsType = QFlags.class.isAssignableFrom(type) ? type : null;
        Class<Object> clazz = enumType = type.isEnum() ? type : null;
        if (enumType == null && flagsType != null) {
            enumType = MetaObjectTools.getEnumForQFlags(flagsType);
        }
        if (enumType == null) {
            return 0;
        }
        Class<?> enclosingClass = enumType.getEnclosingClass();
        if (enclosingClass != null && (!QObject.class.isAssignableFrom(enclosingClass) && !Qt.class.equals(enclosingClass) || enumType.isAnnotationPresent(QtBlockedEnum.class))) {
            return -1;
        }
        int enumConstantCount = 0;
        if (!enums.contains(enumType.getName())) {
            enums.put(enumType.getName(), enumType);
            enumConstantCount = enumType.getEnumConstants().length;
        }
        if (flagsType != null && !enums.contains(flagsType.getName())) {
            enums.put(flagsType.getName(), flagsType);
        }
        return enumConstantCount;
    }

    private static Object isDesignable(Method declaredMethod, Class<?> clazz) {
        QtPropertyDesignable designable = declaredMethod.getAnnotation(QtPropertyDesignable.class);
        if (designable != null) {
            String value = designable.value();
            if (value.equals("true")) {
                return Boolean.TRUE;
            }
            if (value.equals("false")) {
                return Boolean.FALSE;
            }
            try {
                Method m = clazz.getMethod(value, null);
                if (MetaObjectTools.isBoolean(m.getReturnType())) {
                    return m;
                }
                throw new RuntimeException("Wrong return type of designable method '" + m.getName() + "'");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return Boolean.TRUE;
    }

    private static boolean isValidSetter(Method declaredMethod) {
        return declaredMethod.getParameterTypes().length == 1 && declaredMethod.getReturnType() == Void.TYPE && !MetaObjectTools.internalTypeNameOfParameters(declaredMethod, 1).equals("");
    }

    private static Method getMethod(Class<?> clazz, String name, Class<?>[] args) {
        try {
            return clazz.getMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static String capitalizeFirst(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    private static boolean isBoolean(Class<?> type) {
        return type == Boolean.class || type == Boolean.TYPE;
    }

    private static Boolean isUser(Method m) {
        return m.getAnnotation(QtPropertyUser.class) != null;
    }

    private static boolean isValidGetter(Method method) {
        return method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    public static String bunchOfClassNamesInARow(Class<?>[] classes) {
        return MetaObjectTools.bunchOfClassNamesInARow(classes, null);
    }

    public static String bunchOfClassNamesInARow(Class<?>[] classes, int[] arrayDimensions) {
        String classNames = "";
        for (int i = 0; i < classes.length; ++i) {
            Class<?> clazz = classes[i];
            String className = clazz.getName();
            if (arrayDimensions != null) {
                for (int j = 0; j < arrayDimensions[i]; ++j) {
                    className = "java.lang.Object";
                }
            }
            if (!clazz.isPrimitive()) {
                try {
                    MetaObjectTools.class.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    className = QObject.class.isAssignableFrom(clazz) ? QObject.class.getName() : Object.class.getName();
                }
            }
            classNames = classNames + className;
            if (i >= classes.length - 1) continue;
            classNames = classNames + ",";
        }
        return classNames;
    }

    private static String methodParameters(Method m) {
        return MetaObjectTools.bunchOfClassNamesInARow(m.getParameterTypes());
    }

    private static String methodSignature(Method m, boolean includeReturnType) {
        return (includeReturnType ? m.getReturnType().getName() + " " : "") + m.getName() + "(" + MetaObjectTools.methodParameters(m) + ")";
    }

    public static String methodSignature(Method m) {
        return MetaObjectTools.methodSignature(m, false);
    }

    private static int addString(int[] metaData, Hashtable<String, Integer> strings, List<String> stringsInOrder, String string, int offset, int metaDataOffset) {
        if (strings.containsKey(string)) {
            metaData[metaDataOffset] = strings.get(string);
            return 0;
        }
        metaData[metaDataOffset] = offset;
        strings.put(string, offset);
        stringsInOrder.add(string);
        return string.length() + 1;
    }

    public static native void emitNativeSignal(QObject var0, String var1, String var2, Object[] var3);

    public static String cppSignalSignature(QSignalEmitterInternal signalEmitter, String signalName) {
        QSignalEmitter.AbstractSignal signal = (QSignalEmitter.AbstractSignal)QtJambiInternal.lookupSignal(signalEmitter, signalName);
        if (signal != null) {
            return MetaObjectTools.cppSignalSignature(signal);
        }
        return "";
    }

    public static String cppSignalSignature(QSignalEmitterInternal.AbstractSignalInternal signal) {
        String signalParameters = QtJambiInternal.signalParameters(signal);
        String params = MetaObjectTools.internalTypeNameOfSignal(signal.resolveSignal(), signalParameters, 1);
        if (signalParameters.length() > 0 && params.length() == 0) {
            return "";
        }
        return signal.name() + "(" + params + ")";
    }

    private static String signalParameters(QtJambiInternal.ResolvedSignal resolvedSignal) {
        return MetaObjectTools.bunchOfClassNamesInARow(resolvedSignal.types, resolvedSignal.arrayDimensions);
    }

    private static String signalParameters(Field field, Class<?> declaringClass) {
        QtJambiInternal.ResolvedSignal resolvedSignal = QtJambiInternal.resolveSignal(field, declaringClass);
        return MetaObjectTools.signalParameters(resolvedSignal);
    }

    private static native String internalTypeName(String var0, int var1);

    public static String internalTypeNameOfSignal(Class<?>[] signals, String s, int varContext) {
        try {
            return MetaObjectTools.internalTypeName(s, varContext);
        }
        catch (Throwable t) {
            return "";
        }
    }

    public static String internalTypeNameOfParameters(Method declaredMethod, int varContext) {
        try {
            String s = MetaObjectTools.methodParameters(declaredMethod);
            return MetaObjectTools.internalTypeName(s, varContext);
        }
        catch (Throwable t) {
            return "";
        }
    }

    public static String internalTypeNameOfMethodSignature(Method slot, int varContext) {
        try {
            String javaMethodSignature = MetaObjectTools.methodSignature(slot);
            return MetaObjectTools.internalTypeName(javaMethodSignature, varContext);
        }
        catch (Throwable t) {
            return "";
        }
    }

    public static String internalTypeNameOfClass(Class cls, int varContext) {
        try {
            String returnType = cls.getName();
            if (!cls.isPrimitive()) {
                try {
                    MetaObjectTools.class.getClassLoader().loadClass(returnType);
                }
                catch (Exception e) {
                    returnType = QObject.class.isAssignableFrom(cls) ? QObject.class.getName() : Object.class.getName();
                }
            }
            return MetaObjectTools.internalTypeName(returnType, varContext);
        }
        catch (Throwable t) {
            return "";
        }
    }

    private static MetaData buildMetaData(Class<? extends QObject> clazz) {
        int i;
        Method[] declaredMethods;
        MetaData metaData = new MetaData();
        ArrayList<Method> slots = new ArrayList<Method>();
        Hashtable<String, Method> propertyReaders = new Hashtable<String, Method>();
        Hashtable<String, Method> propertyWriters = new Hashtable<String, Method>();
        Hashtable<String, Object> propertyDesignables = new Hashtable<String, Object>();
        Hashtable<String, Method> propertyResetters = new Hashtable<String, Method>();
        Hashtable<String, Boolean> propertyUser = new Hashtable<String, Boolean>();
        Hashtable enums = new Hashtable();
        int enumConstantCount = MetaObjectTools.queryEnums(clazz, enums);
        int enumCount = enums.size();
        for (Method declaredMethod : declaredMethods = clazz.getDeclaredMethods()) {
            Container resetter;
            Container writer;
            Container reader;
            Class<?> returnType;
            if (!declaredMethod.isAnnotationPresent(QtBlockedSlot.class) && (declaredMethod.getModifiers() & 8) != 8) {
                String methodParameters = MetaObjectTools.methodParameters(declaredMethod);
                returnType = declaredMethod.getReturnType().getName();
                if (!(!methodParameters.equals("") && MetaObjectTools.internalTypeNameOfParameters(declaredMethod, 1).equals("") || !((String)((Object)returnType)).equals("") && !((String)((Object)returnType)).equals("void") && MetaObjectTools.internalTypeNameOfClass(declaredMethod.getReturnType(), 0).equals(""))) {
                    slots.add(declaredMethod);
                }
            }
            if ((reader = Container.readerAnnotation(declaredMethod)) != null && reader.enabled() && MetaObjectTools.isValidGetter(declaredMethod) && !MetaObjectTools.internalTypeNameOfClass(declaredMethod.getReturnType(), 0).equals("")) {
                returnType = declaredMethod.getReturnType();
                int count = MetaObjectTools.putEnumTypeInHash(returnType, enums);
                if (count < 0) {
                    System.err.println("Problem in property '" + reader.name() + "' in '" + clazz.getName() + "': Only enum types 1. declared inside QObject subclasses or the " + "Qt interface and 2. declared without the QtBlockedEnum annotation " + "are supported for properties");
                    continue;
                }
                propertyReaders.put(reader.name(), declaredMethod);
                propertyDesignables.put(reader.name(), MetaObjectTools.isDesignable(declaredMethod, clazz));
                propertyUser.put(reader.name(), MetaObjectTools.isUser(declaredMethod));
            }
            if ((writer = Container.writerAnnotation(declaredMethod)) != null && writer.enabled() && MetaObjectTools.isValidSetter(declaredMethod)) {
                propertyWriters.put(writer.name(), declaredMethod);
            }
            if ((resetter = Container.resetterAnnotation(declaredMethod)) != null && declaredMethod.getParameterTypes().length == 0 && declaredMethod.getReturnType() == Void.TYPE) {
                propertyResetters.put(resetter.name(), declaredMethod);
            }
            if (writer != null || reader != null || !declaredMethod.getName().startsWith("set") || !Character.isUpperCase(declaredMethod.getName().charAt(3)) || !MetaObjectTools.isValidSetter(declaredMethod)) continue;
            Class<?> paramType = declaredMethod.getParameterTypes()[0];
            String propertyName = Character.toLowerCase(declaredMethod.getName().charAt(3)) + declaredMethod.getName().substring(4);
            if (propertyReaders.containsKey(propertyName)) continue;
            Method readerMethod = MetaObjectTools.notBogus(MetaObjectTools.getMethod(clazz, propertyName, null), propertyName, paramType);
            if (readerMethod == null) {
                readerMethod = MetaObjectTools.notBogus(MetaObjectTools.getMethod(clazz, "get" + MetaObjectTools.capitalizeFirst(propertyName), null), propertyName, paramType);
            }
            if (readerMethod == null && MetaObjectTools.isBoolean(paramType)) {
                readerMethod = MetaObjectTools.notBogus(MetaObjectTools.getMethod(clazz, "is" + MetaObjectTools.capitalizeFirst(propertyName), null), propertyName, paramType);
            }
            if (readerMethod == null && MetaObjectTools.isBoolean(paramType)) {
                readerMethod = MetaObjectTools.notBogus(MetaObjectTools.getMethod(clazz, "has" + MetaObjectTools.capitalizeFirst(propertyName), null), propertyName, paramType);
            }
            if (readerMethod == null || (reader = Container.readerAnnotation(readerMethod)) != null) continue;
            propertyReaders.put(propertyName, readerMethod);
            propertyWriters.put(propertyName, declaredMethod);
            propertyDesignables.put(propertyName, MetaObjectTools.isDesignable(readerMethod, clazz));
            propertyUser.put(propertyName, MetaObjectTools.isUser(readerMethod));
        }
        Field[] declaredFields = clazz.getDeclaredFields();
        ArrayList<Field> signalFields = new ArrayList<Field>();
        ArrayList<QtJambiInternal.ResolvedSignal> resolvedSignals = new ArrayList<QtJambiInternal.ResolvedSignal>();
        for (Field declaredField : declaredFields) {
            QtJambiInternal.ResolvedSignal resolvedSignal;
            String signalParameters;
            if (!QtJambiInternal.isSignal(declaredField.getType()) || (signalParameters = MetaObjectTools.signalParameters(resolvedSignal = QtJambiInternal.resolveSignal(declaredField, declaredField.getDeclaringClass()))).length() != 0 && MetaObjectTools.internalTypeNameOfSignal(resolvedSignal.types, signalParameters, 1).length() == 0) continue;
            signalFields.add(declaredField);
            resolvedSignals.add(resolvedSignal);
        }
        metaData.signalsArray = signalFields.toArray(new Field[0]);
        int functionCount = slots.size() + signalFields.size();
        int propertyCount = propertyReaders.keySet().size();
        metaData.metaData = new int[12 + functionCount * 5 + 1 + propertyCount * 3 + enumCount * 4 + enumConstantCount * 2];
        metaData.metaData[0] = 1;
        metaData.metaData[2] = 1;
        metaData.metaData[3] = 10;
        metaData.metaData[4] = functionCount;
        metaData.metaData[5] = functionCount > 0 ? 12 : 0;
        metaData.metaData[6] = propertyCount;
        metaData.metaData[7] = 12 + functionCount * 5;
        metaData.metaData[8] = enumCount;
        metaData.metaData[9] = 12 + functionCount * 5 + propertyCount * 3;
        int offset = 0;
        int metaDataOffset = 10;
        Hashtable<String, Integer> strings = new Hashtable<String, Integer>();
        ArrayList<String> stringsInOrder = new ArrayList<String>();
        String className = clazz.getName().replace(".", "::");
        stringsInOrder.add(className);
        strings.put(className, offset);
        offset += className.length() + 1;
        offset += MetaObjectTools.addString(metaData.metaData, strings, stringsInOrder, "__qt__binding_shell_language", offset, metaDataOffset++);
        offset += MetaObjectTools.addString(metaData.metaData, strings, stringsInOrder, "Qt Jambi", offset, metaDataOffset++);
        metaData.originalSignatures = new String[signalFields.size() + slots.size()];
        for (i = 0; i < signalFields.size(); ++i) {
            Field signalField = (Field)signalFields.get(i);
            QtJambiInternal.ResolvedSignal resolvedSignal = (QtJambiInternal.ResolvedSignal)resolvedSignals.get(i);
            String javaSignalParameters = MetaObjectTools.signalParameters(resolvedSignal);
            metaData.originalSignatures[i] = resolvedSignal.name + (javaSignalParameters.length() > 0 ? '<' + javaSignalParameters + '>' : "");
            String signalParameters = MetaObjectTools.internalTypeNameOfSignal(resolvedSignal.types, javaSignalParameters, 1);
            offset += MetaObjectTools.addString(metaData.metaData, strings, stringsInOrder, resolvedSignal.name + "(" + signalParameters + ")", offset, metaDataOffset++);
            offset += MetaObjectTools.addString(metaData.metaData, strings, stringsInOrder, signalParameters, offset, metaDataOffset++);
            offset += MetaObjectTools.addString(metaData.metaData, strings, stringsInOrder, "", offset, metaDataOffset++);
            offset += MetaObjectTools.addString(metaData.metaData, strings, stringsInOrder, "", offset, metaDataOffset++);
            int flags = 4;
            int modifiers = signalField.getModifiers();
            if ((modifiers & 2) == 2) {
                flags |= 0;
            } else if ((modifiers & 4) == 4) {
                flags |= 1;
            } else if ((modifiers & 1) == 1) {
                flags |= 2;
            }
            metaData.metaData[metaDataOffset++] = flags;
        }
        for (i = 0; i < slots.size(); ++i) {
            String javaMethodSignature;
            Method slot = (Method)slots.get(i);
            metaData.originalSignatures[signalFields.size() + i] = javaMethodSignature = MetaObjectTools.methodSignature(slot);
            offset += MetaObjectTools.addString(metaData.metaData, strings, stringsInOrder, MetaObjectTools.internalTypeNameOfMethodSignature(slot, 1), offset, metaDataOffset++);
            offset += MetaObjectTools.addString(metaData.metaData, strings, stringsInOrder, MetaObjectTools.internalTypeNameOfParameters(slot, 1), offset, metaDataOffset++);
            String returnType = slot.getReturnType().getName();
            if (returnType.equals("void")) {
                returnType = "";
            }
            offset += MetaObjectTools.addString(metaData.metaData, strings, stringsInOrder, MetaObjectTools.internalTypeNameOfClass(slot.getReturnType(), 0), offset, metaDataOffset++);
            offset += MetaObjectTools.addString(metaData.metaData, strings, stringsInOrder, "", offset, metaDataOffset++);
            int flags = 8;
            int modifiers = slot.getModifiers();
            if ((modifiers & 2) == 2) {
                flags |= 0;
            } else if ((modifiers & 4) == 4) {
                flags |= 1;
            } else if ((modifiers & 1) == 1) {
                flags |= 2;
            }
            metaData.metaData[metaDataOffset++] = flags;
        }
        metaData.slotsArray = slots.toArray(new Method[0]);
        String[] propertyNames = propertyReaders.keySet().toArray(new String[0]);
        metaData.propertyReadersArray = new Method[propertyNames.length];
        metaData.propertyResettersArray = new Method[propertyNames.length];
        metaData.propertyWritersArray = new Method[propertyNames.length];
        metaData.propertyDesignablesArray = new Method[propertyNames.length];
        for (int i2 = 0; i2 < propertyNames.length; ++i2) {
            Method reader = (Method)propertyReaders.get(propertyNames[i2]);
            Method writer = (Method)propertyWriters.get(propertyNames[i2]);
            Method resetter = (Method)propertyResetters.get(propertyNames[i2]);
            Object designableVariant = propertyDesignables.get(propertyNames[i2]);
            boolean isUser = (Boolean)propertyUser.get(propertyNames[i2]);
            if (writer != null && !reader.getReturnType().isAssignableFrom(writer.getParameterTypes()[0])) {
                System.err.println("QtJambiInternal.buildMetaData: Writer for property " + propertyNames[i2] + " takes a type which is incompatible with reader's return type.");
                writer = null;
            }
            offset += MetaObjectTools.addString(metaData.metaData, strings, stringsInOrder, propertyNames[i2], offset, metaDataOffset++);
            Class<?> t = reader.getReturnType();
            boolean isEnumOrFlags = Enum.class.isAssignableFrom(t) || QFlags.class.isAssignableFrom(t);
            String typeName = null;
            typeName = isEnumOrFlags && t.getDeclaringClass() != null && QObject.class.isAssignableFrom(t.getDeclaringClass()) ? t.getDeclaringClass().getName().replace(".", "::") + "::" + t.getSimpleName() : MetaObjectTools.internalTypeNameOfClass(t, 0);
            offset += MetaObjectTools.addString(metaData.metaData, strings, stringsInOrder, typeName, offset, metaDataOffset++);
            int designableFlags = 0;
            if (designableVariant instanceof Boolean) {
                if (((Boolean)designableVariant).booleanValue()) {
                    designableFlags = 4096;
                }
            } else if (designableVariant instanceof Method) {
                designableFlags = 8192;
                metaData.propertyDesignablesArray[i2] = (Method)designableVariant;
            }
            metaData.metaData[metaDataOffset++] = 0x10001 | designableFlags | (writer != null ? 2 : 0) | (resetter != null ? 4 : 0) | (isEnumOrFlags ? 8 : 0) | (isUser ? 0x100000 : 0);
            metaData.propertyReadersArray[i2] = reader;
            metaData.propertyWritersArray[i2] = writer;
            metaData.propertyResettersArray[i2] = resetter;
        }
        int enumConstantOffset = metaDataOffset + enumCount * 4;
        Hashtable<String, Class<? extends QObject>> enclosingClasses = new Hashtable<String, Class<? extends QObject>>();
        Collection<Class<?>> classes = enums.values();
        for (Class<?> cls : classes) {
            Class<? extends QObject> enclosingClass = cls.getEnclosingClass();
            if (enclosingClass.equals(clazz)) {
                Class<?> enumClass;
                offset += MetaObjectTools.addString(metaData.metaData, strings, stringsInOrder, cls.getSimpleName(), offset, metaDataOffset++);
                metaData.metaData[metaDataOffset++] = QFlags.class.isAssignableFrom(cls) ? 1 : 0;
                Class<Object> clazz2 = enumClass = Enum.class.isAssignableFrom(cls) ? cls : null;
                if (enumClass == null) {
                    enumClass = MetaObjectTools.getEnumForQFlags(cls);
                }
                enumConstantCount = enumClass.getEnumConstants().length;
                metaData.metaData[metaDataOffset++] = enumConstantCount;
                metaData.metaData[metaDataOffset++] = enumConstantOffset;
                enumConstantOffset += 2 * enumConstantCount;
                continue;
            }
            if (enclosingClass.isAssignableFrom(clazz) || enclosingClasses.contains(enclosingClass.getName())) continue;
            enclosingClasses.put(enclosingClass.getName(), enclosingClass);
        }
        metaData.extraDataArray = enclosingClasses.values().toArray(new Class[0]);
        for (Class<?> cls : classes) {
            Enum[] enumConstants;
            Class<?> enumClass;
            if (!cls.getEnclosingClass().equals(clazz)) continue;
            Class<Object> clazz3 = enumClass = Enum.class.isAssignableFrom(cls) ? cls : null;
            if (enumClass == null) {
                enumClass = MetaObjectTools.getEnumForQFlags(cls);
            }
            for (Enum enumConstant : enumConstants = (Enum[])enumClass.getEnumConstants()) {
                offset += MetaObjectTools.addString(metaData.metaData, strings, stringsInOrder, enumConstant.name(), offset, metaDataOffset++);
                metaData.metaData[metaDataOffset++] = enumConstant instanceof QtEnumerator ? ((QtEnumerator)((Object)enumConstant)).value() : enumConstant.ordinal();
            }
        }
        metaData.metaData[metaDataOffset++] = 0;
        int stringDataOffset = 0;
        metaData.stringData = new byte[offset + 1];
        for (String s : stringsInOrder) {
            assert (stringDataOffset == strings.get(s));
            System.arraycopy(s.getBytes(), 0, metaData.stringData, stringDataOffset, s.length());
            stringDataOffset += s.length();
            metaData.stringData[stringDataOffset++] = 0;
        }
        return metaData;
    }

    private static class MetaData {
        public int[] metaData;
        public byte[] stringData;
        public Field[] signalsArray;
        public Method[] slotsArray;
        public Method[] propertyReadersArray;
        public Method[] propertyWritersArray;
        public Method[] propertyResettersArray;
        public Method[] propertyDesignablesArray;
        public Class<?>[] extraDataArray;
        public String[] originalSignatures;

        private MetaData() {
        }
    }

    private static class Container {
        private Method method;
        private String name = null;
        private boolean enabled;
        private AnnotationType type;

        private Container(String name, Method method, boolean enabled, AnnotationType type) {
            this.name = name;
            this.method = method;
            this.enabled = enabled;
            this.type = type;
        }

        private Container(QtPropertyReader reader, Method method) {
            this(reader.name(), method, reader.enabled(), AnnotationType.Reader);
        }

        private Container(QtPropertyWriter writer, Method method) {
            this(writer.name(), method, writer.enabled(), AnnotationType.Writer);
        }

        private Container(QtPropertyResetter resetter, Method method) {
            this(resetter.name(), method, resetter.enabled(), AnnotationType.Resetter);
        }

        private static String removeAndLowercaseFirst(String name, int count) {
            return Character.toLowerCase(name.charAt(count)) + name.substring(count + 1);
        }

        private String getNameFromMethod(Method method) {
            if (this.type == AnnotationType.Resetter) {
                return "";
            }
            if (this.type == AnnotationType.Reader) {
                String name = method.getName();
                if (name.startsWith("get")) {
                    name = Container.removeAndLowercaseFirst(name, 3);
                } else if (MetaObjectTools.isBoolean(method.getReturnType()) && name.startsWith("is")) {
                    name = Container.removeAndLowercaseFirst(name, 2);
                } else if (MetaObjectTools.isBoolean(method.getReturnType()) && name.startsWith("has")) {
                    name = Container.removeAndLowercaseFirst(name, 3);
                }
                return name;
            }
            String name = method.getName();
            if (!name.startsWith("set")) {
                throw new IllegalArgumentException("The correct pattern for setter accessor names is setXxx where Xxx is the property name with upper case initial.");
            }
            name = Container.removeAndLowercaseFirst(name, 3);
            return name;
        }

        private String name() {
            if (this.name == null || this.name.length() == 0) {
                this.name = this.getNameFromMethod(this.method);
            }
            return this.name;
        }

        private boolean enabled() {
            return this.enabled;
        }

        private static Container readerAnnotation(Method method) {
            QtPropertyReader reader = method.getAnnotation(QtPropertyReader.class);
            return reader == null ? null : new Container(reader, method);
        }

        private static Container writerAnnotation(Method method) {
            QtPropertyWriter writer = method.getAnnotation(QtPropertyWriter.class);
            return writer == null ? null : new Container(writer, method);
        }

        private static Container resetterAnnotation(Method method) {
            QtPropertyResetter resetter = method.getAnnotation(QtPropertyResetter.class);
            return resetter == null ? null : new Container(resetter, method);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum AnnotationType {
            Reader,
            Writer,
            Resetter;

        }
    }
}

